/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy.impls;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.asymmetric.AsymmetricAlgorithm;
import edu.vt.middleware.crypt.asymmetric.RSA;
import edu.vt.middleware.crypt.util.Base64Converter;
import edu.vt.middleware.crypt.util.Converter;
import edu.vt.middleware.crypt.util.CryptReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import org.refcodes.exception.traps.HiddenException;
import org.refcodes.exception.utils.ExceptionUtility;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.factories.CipherVersionFactory;
import org.refcodes.forwardsecrecy.factories.impls.CipherVersionFactoryImpl;
import org.refcodes.forwardsecrecy.generators.CipherVersionGenerator;
import org.refcodes.forwardsecrecy.generators.impls.CipherVersionGeneratorImpl;
import org.refcodes.forwardsecrecy.impls.AbstractEncryptionService;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.factories.impls.RuntimeLoggerFactorySingleton;

public class PublicKeyEncryptionServiceImpl
extends AbstractEncryptionService {
    private static RuntimeLogger LOGGER = (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance();
    private CipherVersionFactory<CipherVersion> _cipherVersionFactory;
    private AsymmetricAlgorithm _encryptAlgorithm = new RSA();
    private Base64Converter _base64Converter = new Base64Converter();
    private String _publicKeyPath;

    public PublicKeyEncryptionServiceImpl(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer) throws CryptException, IOException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, new CipherVersionGeneratorImpl(), new CipherVersionFactoryImpl());
    }

    public PublicKeyEncryptionServiceImpl(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator) throws CryptException, IOException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, aCipherVersionGenerator, new CipherVersionFactoryImpl());
    }

    public PublicKeyEncryptionServiceImpl(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws CryptException, IOException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, new CipherVersionGeneratorImpl(), aCipherVersionFactory);
    }

    public PublicKeyEncryptionServiceImpl(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws CryptException, IOException {
        super(aNamespace, aEncryptionServer, aCipherVersionGenerator);
        this._cipherVersionFactory = aCipherVersionFactory;
        this._publicKeyPath = aPublicKeyPath;
        File thePublicKeyFile = new File(aPublicKeyPath);
        LOGGER.debug("Loading public key from file \"" + thePublicKeyFile.getAbsolutePath() + "\"...");
        try {
            PublicKey thePublicKey = CryptReader.readPublicKey((File)thePublicKeyFile);
            this._encryptAlgorithm.setKey((Key)thePublicKey);
            this._encryptAlgorithm.initEncrypt();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Unable to load public key from file \"" + thePublicKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
    }

    @Override
    protected <CV extends CipherVersion> CV toEncryptedCipherVersion(CV aDecryptedCipherVersion) {
        LOGGER.debug("Using public key \"" + this._publicKeyPath + "\" for encrypting ...");
        try {
            return (CV)this._cipherVersionFactory.createInstance(aDecryptedCipherVersion.getUniversalId(), this._encryptAlgorithm.encrypt(aDecryptedCipherVersion.getCipher().getBytes(), (Converter)this._base64Converter));
        }
        catch (CryptException e) {
            throw new HiddenException((Throwable)e);
        }
    }
}

