/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy.utils;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.jasypt.util.text.BasicTextEncryptor;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.factories.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.textual.utils.AlignTextUtility;
import org.refcodes.textual.utils.RandomTextUtility;

public final class ForwardSecrecyUtility {
    private static final char CIPHER_UID_TIMESTAMP_SEPARATOR = '-';
    public static final int CIPHER_UID_TIMESTAMP_LENGTH = 14;
    public static final int CIPHER_UID_LENGTH = 24;
    public static final int CIPHER_LENGTH = 48;
    public static final int MESSAGE_LENGTH = 256;
    private static RuntimeLogger LOGGER = (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance();
    private static BasicTextEncryptor TEXT_ENCRYPTOR;

    private ForwardSecrecyUtility() {
    }

    public static boolean hasEncryptionPattern(String aText) {
        if (aText.length() < 24) {
            return false;
        }
        if (aText.charAt(24) != ':') {
            return false;
        }
        return aText.charAt(13) == '-';
    }

    public static String toCipherUidPrefix(String aCipherUidWithEncryptedText) {
        int theIndex = aCipherUidWithEncryptedText.indexOf(58);
        if (theIndex == -1) {
            return null;
        }
        return aCipherUidWithEncryptedText.substring(0, theIndex);
    }

    public static String toEncryptedTextBody(String aCipherUidWithEncryptedText) {
        int theIndex = aCipherUidWithEncryptedText.indexOf(58);
        if (theIndex == -1) {
            return null;
        }
        return aCipherUidWithEncryptedText.substring(theIndex + 1);
    }

    public static String createCipherUid() {
        String theCipherUid = System.currentTimeMillis() + "" + '-';
        theCipherUid = AlignTextUtility.toAlignRight((String)theCipherUid, (int)14, (char)'0');
        theCipherUid = theCipherUid + RandomTextUtility.toRandomAlphanumeric((int)(24 - theCipherUid.length()));
        return theCipherUid;
    }

    public static String createCipher() {
        String theCipher = RandomTextUtility.toRandomAlphanumeric((int)48);
        return theCipher;
    }

    public static String createMessage() {
        String theCipher = RandomTextUtility.toRandomAlphanumeric((int)256);
        return theCipher;
    }

    static {
        String thePassPhrase = null;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface eNetworkInterface = e.nextElement();
                try {
                    byte[] eHardwareAddress = eNetworkInterface.getHardwareAddress();
                    if (eHardwareAddress == null) continue;
                    thePassPhrase = "";
                    for (int i = 0; i < eHardwareAddress.length; ++i) {
                        thePassPhrase = thePassPhrase + (eHardwareAddress[i] < 0 ? "" + (eHardwareAddress[i] & 0xFF) : "" + eHardwareAddress[i]);
                        if (i >= eHardwareAddress.length - 1) continue;
                        thePassPhrase = thePassPhrase + ".";
                    }
                    break;
                }
                catch (SocketException se) {
                    LOGGER.warn("Unable to aquire network interfaces's (\"" + eNetworkInterface.getDisplayName() + "\") hardware address, tyring next network interface.", (Throwable)se);
                }
            }
        }
        catch (SocketException se) {
            LOGGER.warn("Unable to aquire machine's network interfaces (using alternate cipher).", (Throwable)se);
        }
        if (thePassPhrase == null) {
            thePassPhrase = "=============================================================================\nREFCODES.ORG\n=============================================================================\nThis code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed\nunder the following (see \"http://en.wikipedia.org/wiki/Multi-licensing\")\nlicenses:\n=============================================================================\nGNU General Public License, v3.0 (\"http://www.gnu.org/licenses/gpl-3.0.html\")\n=============================================================================\nApache License, v2.0 (\"http://www.apache.org/licenses/LICENSE-2.0\")\n=============================================================================\nPlease contact the copyright holding author(s) of the software artifacts in\nquestion for licensing issues not being covered by the above listed licenses,\nalso regarding commercial licensing models or regarding the compatibility\nwith other open source licenses.\n=============================================================================\n";
        }
        TEXT_ENCRYPTOR = new BasicTextEncryptor();
        TEXT_ENCRYPTOR.setPassword(thePassPhrase);
    }
}

