/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.refcodes.io.FileUtility;
import org.refcodes.textual.SeparatedValuesUtility;

public class FileUtilityTest {
    private static Logger LOGGER = Logger.getLogger(FileUtilityTest.class);
    private static final String[][] ZIP_FILE_NAMES = new String[][]{{"test.log.zip", "test.log"}, {"test.log.ZIP", "test.log"}, {"home/user/test.log.zip", "home/user/test.log"}, {".zip", ""}};

    @Test
    public void toAutoDetectInputStream() {
        for (int i = 0; i < ZIP_FILE_NAMES.length; ++i) {
            LOGGER.info((Object)("In:      \"" + ZIP_FILE_NAMES[i][0] + "\""));
            LOGGER.info((Object)("Out:     \"" + FileUtility.toFileNameFromZip((String)ZIP_FILE_NAMES[i][0]) + "\""));
            LOGGER.info((Object)("Expected:\"" + ZIP_FILE_NAMES[i][1] + "\""));
            Assert.assertEquals((Object)ZIP_FILE_NAMES[i][1], (Object)FileUtility.toFileNameFromZip((String)ZIP_FILE_NAMES[i][0]));
        }
    }

    @Test
    public void toJarHierarchy() throws MalformedURLException {
        URL theJarPath1 = new URL("jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml");
        URL theJarPath2 = new URL("jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/lib/fightclub-adapter-web-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml");
        Object[] theJarHierarchy = FileUtility.toJarHierarchy((URL)theJarPath1);
        String theJarPath = SeparatedValuesUtility.toSeparatedValues((Object[])theJarHierarchy, (char)'/');
        LOGGER.info((Object)("JAR parh 1 := " + theJarPath));
        Assert.assertEquals((Object)"fightclub-app-0.0.1-SNAPSHOT.jar", (Object)theJarPath);
        theJarHierarchy = FileUtility.toJarHierarchy((URL)theJarPath2);
        theJarPath = SeparatedValuesUtility.toSeparatedValues((Object[])theJarHierarchy, (char)'/');
        LOGGER.info((Object)("JAR parh 2 := " + theJarPath));
        Assert.assertEquals((Object)"fightclub-app-0.0.1-SNAPSHOT.jar/fightclub-adapter-web-0.0.1-SNAPSHOT.jar", (Object)theJarPath);
    }
}

