/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io.impls;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.component.impls.AbstractConnectableAutomaton;
import org.refcodes.controlflow.impls.RetryCounterImpl;
import org.refcodes.io.ByteReceiver;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;

public abstract class AbstractByteReceiver
extends AbstractConnectableAutomaton
implements ByteReceiver {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    public static final int DATAGRAM_QUEUE_SIZE = 1024;
    protected LinkedBlockingQueue<Byte> _datagramQueue;

    public AbstractByteReceiver() {
        this._datagramQueue = new LinkedBlockingQueue(1024);
    }

    public AbstractByteReceiver(int aCapacity) {
        this._datagramQueue = new LinkedBlockingQueue(aCapacity);
    }

    @Override
    public byte readDatagram() throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        return this._datagramQueue.take();
    }

    @Override
    public byte[] readDatagrams() throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        ArrayList theBytes = new ArrayList();
        this._datagramQueue.drainTo(theBytes);
        byte[] theDatagrams = new byte[theBytes.size()];
        for (int i = 0; i < theDatagrams.length; ++i) {
            theDatagrams[i] = (Byte)theBytes.get(i);
        }
        return theDatagrams;
    }

    @Override
    public boolean hasDatagram() throws OpenException {
        return !this._datagramQueue.isEmpty();
    }

    public void close() throws CloseException {
        if (this.isOpened()) {
            super.close();
            this.releaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        LinkedBlockingQueue<Byte> linkedBlockingQueue = this._datagramQueue;
        synchronized (linkedBlockingQueue) {
            this._datagramQueue.notifyAll();
        }
    }

    protected void pushDatagram(byte aDatagram) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to push datagram <" + aDatagram + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(7);
        try {
            while (!this._datagramQueue.offer(aDatagram, 3000L, TimeUnit.MILLISECONDS) && theRetryCounter.nextRetry()) {
                LOGGER.warn("Trying to offer (add) a datagram to the datagram queue, though the queue is full, this is retry # <" + theRetryCounter.getRetryCount() + ">, aborting after <" + theRetryCounter.getRetryNumber() + "> retries. Retrying now after a delay of <" + 3L + "> seconds...");
                if (theRetryCounter.hasNextRetry()) continue;
                throw new OpenException("Unable to process the datagram after <" + theRetryCounter.getRetryNumber() + "> retries, aborting retries, dismissing datagram \"" + aDatagram + "\"!", null, null);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

