/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io.impls;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.io.OutputStreamConnectionSender;
import org.refcodes.io.impls.AbstractSender;

public class OutputStreamConnectionSenderImpl<DATA extends Serializable>
extends AbstractSender<DATA>
implements OutputStreamConnectionSender<DATA> {
    private ObjectOutputStream _objectOutputStream = null;

    public synchronized void open(OutputStream aOutputStream) throws OpenException {
        if (this.isOpened()) {
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        try {
            this._objectOutputStream = aOutputStream instanceof ObjectOutputStream ? (ObjectOutputStream)aOutputStream : (!(aOutputStream instanceof BufferedOutputStream) ? new ObjectOutputStream(new BufferedOutputStream(aOutputStream)) : new ObjectOutputStream(aOutputStream));
            this._objectOutputStream.flush();
        }
        catch (IOException aException) {
            throw new OpenException("Unable to open the I/O stream receiver as of a causing exception.", (Throwable)aException);
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    public boolean isOpenable(OutputStream aOutputStream) {
        if (aOutputStream == null) {
            return false;
        }
        return !this.isOpened();
    }

    public void flush() throws OpenException {
        try {
            this._objectOutputStream.flush();
        }
        catch (IOException e) {
            throw new OpenException("Unable to flush underlying output stream <" + this._objectOutputStream + ">.", (Throwable)e);
        }
    }

    public synchronized void close() throws CloseException {
        super.close();
        try {
            this._objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDatagram(DATA aDatagram) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagram.getClass().getName() + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        ObjectOutputStream objectOutputStream = this._objectOutputStream;
        synchronized (objectOutputStream) {
            try {
                this._objectOutputStream.writeObject(aDatagram);
                this._objectOutputStream.flush();
            }
            catch (IOException aException) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.close();
                }
                catch (CloseException e) {
                    throw new OpenException("Unable to close malfunctioning connection.", (Throwable)e);
                }
                throw new OpenException((Throwable)aException);
            }
        }
    }
}

