// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import org.refcodes.component.Closable;
import org.refcodes.component.CloseException;
import org.refcodes.component.Flushable;
import org.refcodes.component.OpenException;

/**
 * The {@link ShortSenderDecorator} decorates a {@link ShortConsumer} with the
 * additional methods of a {@link ShortSender} making it easy to use a
 * {@link ShortConsumer} wherever a {@link ShortSender} is expected.
 */
public class ShortSenderDecorator extends AbstractShortSender implements ShortSender {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private ShortConsumer _shortConsumer;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new short sender decorator.
	 *
	 * @param aShortConsumer the short consumer
	 */
	public ShortSenderDecorator( ShortConsumer aShortConsumer ) {
		_shortConsumer = aShortConsumer;
		try {
			open();
		}
		catch ( OpenException ignore ) {}
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagram( short aDatagram ) throws OpenException {
		_shortConsumer.writeDatagram( aDatagram );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagrams( short[] aDatagrams ) throws OpenException {
		_shortConsumer.writeDatagrams( aDatagrams );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagrams( short[] aDatagrams, int aOffset, int aLength ) throws OpenException {
		_shortConsumer.writeDatagrams( aDatagrams, aOffset, aLength );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void flush() throws OpenException {
		if ( _shortConsumer instanceof Flushable ) {
			((Flushable) _shortConsumer).flush();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws CloseException {
		if ( _shortConsumer instanceof Closable ) {
			((Closable) _shortConsumer).close();
		}
		super.close();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
