/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.util.concurrent.LinkedBlockingQueue;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.io.AbstractByteProvider;
import org.refcodes.io.ByteReceiver;

public abstract class AbstractByteReceiver
extends AbstractByteProvider
implements ByteReceiver {
    protected ConnectableAutomaton _automaton = new ConnectableAutomaton();

    public AbstractByteReceiver() {
    }

    public AbstractByteReceiver(int aCapacity) {
        super(aCapacity);
    }

    @Override
    public byte readDatagram() throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        return super.readDatagram();
    }

    @Override
    public byte[] readDatagrams() throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        return super.readDatagrams();
    }

    @Override
    public byte[] readDatagrams(int aBlockSize) throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        return super.readDatagrams(aBlockSize);
    }

    @Override
    public boolean hasDatagram() throws OpenException {
        return !this._datagramQueue.isEmpty();
    }

    public void close() throws CloseException {
        if (this.isOpened()) {
            this._automaton.close();
            this.releaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        LinkedBlockingQueue linkedBlockingQueue = this._datagramQueue;
        synchronized (linkedBlockingQueue) {
            this._datagramQueue.notifyAll();
        }
    }

    public boolean isOpened() {
        return this._automaton.isOpened();
    }

    public boolean isClosable() {
        return this._automaton.isClosable();
    }

    public boolean isClosed() {
        return this._automaton.isClosed();
    }

    public ConnectionStatus getConnectionStatus() {
        return this._automaton.getConnectionStatus();
    }

    protected void open() throws OpenException {
        this._automaton.open();
    }

    protected void setConnectionStatus(ConnectionStatus aConnectionStatus) {
        this._automaton.setConnectionStatus(aConnectionStatus);
    }

    protected boolean isOpenable() {
        return this._automaton.isOpenable();
    }

    protected static class ConnectableAutomaton
    extends AbstractConnectableAutomaton {
        protected ConnectableAutomaton() {
        }

        public boolean isOpenable() {
            return super.isOpenable();
        }

        public void open() throws OpenException {
            super.open();
        }

        public void setConnectionStatus(ConnectionStatus aConnectionStatus) {
            super.setConnectionStatus(aConnectionStatus);
        }
    }
}

