/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.component.OpenException;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.io.ByteBlockReceiver;
import org.refcodes.io.ByteDatagramReceiver;
import org.refcodes.io.ByteProvider;

public interface ByteReceiver
extends ByteProvider,
ByteDatagramReceiver,
ByteBlockReceiver {
    @Override
    default public byte[] readDatagrams() throws OpenException, InterruptedException {
        ArrayList<Byte> theData = new ArrayList<Byte>();
        while (this.hasDatagram()) {
            theData.add(this.readDatagram());
        }
        byte[] theBytes = new byte[theData.size()];
        for (int i = 0; i < theBytes.length; ++i) {
            theBytes[i] = (Byte)theData.get(i);
        }
        return theBytes;
    }

    @Override
    default public byte[] readDatagrams(int aBlockSize) throws OpenException, InterruptedException {
        int i;
        byte[] theBlock = new byte[aBlockSize];
        for (i = 0; this.hasDatagram() && i < aBlockSize; ++i) {
            theBlock[i] = this.readDatagram();
        }
        if (i == 0) {
            while (!this.hasDatagram()) {
                Thread.sleep(LoopSleepTime.NORM.getMilliseconds());
            }
            while (this.hasDatagram() && i < aBlockSize) {
                theBlock[i] = this.readDatagram();
                ++i;
            }
        }
        if (i == aBlockSize) {
            return theBlock;
        }
        return Arrays.copyOfRange(theBlock, 0, i);
    }
}

