/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.refcodes.data.Encoding;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.io.InputStreamStringBuilder;

public class InputStreamStringBuilderImpl
implements InputStreamStringBuilder {
    private InputStream _inputStream = null;
    private String _lines = null;
    private String _encoding = Encoding.UTF_8.getCode();

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String aEncoding) {
        this._encoding = aEncoding;
    }

    @Override
    public InputStream getInputStream() {
        return this._inputStream;
    }

    @Override
    public void setInputStream(InputStream aInputStream) {
        this._inputStream = aInputStream;
        this._lines = null;
    }

    @Override
    public String toString(InputStream aInputStream, String aEncoding) throws IOException {
        if (aInputStream == null) {
            return null;
        }
        try (Scanner theScanner = new Scanner(aInputStream, aEncoding);){
            theScanner.useDelimiter("\\A");
            String string = theScanner.hasNext() ? theScanner.next() : "";
            return string;
        }
    }

    public String toString() {
        try {
            return this.toString(this._encoding);
        }
        catch (IOException e) {
            throw new HiddenException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    @Override
    public String toString(String aEncoding) throws IOException {
        if (this._lines == null) {
            this._lines = this.toString(this._inputStream, aEncoding);
        }
        return this._lines;
    }

    @Override
    public String[] toStrings() throws IOException {
        if (this._lines == null) {
            this._lines = this.toString(this._inputStream, this._encoding);
        }
        return this._lines.split("\\r\\n|\\n|\\r");
    }
}

