/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.io.AbstractByteSender;
import org.refcodes.io.OutputStreamConnectionByteSender;

public class OutputStreamConnectionByteSenderImpl
extends AbstractByteSender
implements OutputStreamConnectionByteSender {
    private OutputStream _outputStream = null;

    public synchronized void open(OutputStream aOutputStream) throws OpenException {
        if (this.isOpened()) {
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        try {
            this._outputStream = aOutputStream;
            this._outputStream.flush();
        }
        catch (IOException aException) {
            throw new OpenException("Unable to open the I/O stream receiver as of a causing exception.", (Throwable)aException);
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    public boolean isOpenable(OutputStream aOutputStream) {
        if (aOutputStream == null) {
            return false;
        }
        return !this.isOpened();
    }

    @Override
    public void flush() throws OpenException {
        try {
            this._outputStream.flush();
        }
        catch (IOException e) {
            throw new OpenException("Unable to flush underlying output stream <" + this._outputStream + ">.", (Throwable)e);
        }
    }

    public synchronized void close() throws CloseException {
        super.close();
        try {
            this._outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDatagram(byte aDatagram) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagram + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        OutputStream outputStream = this._outputStream;
        synchronized (outputStream) {
            try {
                this._outputStream.write(aDatagram);
                this._outputStream.flush();
            }
            catch (IOException aException) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.close();
                }
                catch (CloseException e) {
                    throw new OpenException("Unable to close malfunctioning connection.", (Throwable)e);
                }
                throw new OpenException((Throwable)aException);
            }
        }
    }
}

