/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipException;
import org.refcodes.tabular.CsvFileRecordsImpl;
import org.refcodes.tabular.Header;

public class ZipFileInputStreamImpl
extends BufferedInputStream {
    public ZipFileInputStreamImpl(File parent, String child) throws ZipException, FileNotFoundException, IOException {
        this(new File(parent, child));
    }

    public ZipFileInputStreamImpl(String parent, String child) throws ZipException, FileNotFoundException, IOException {
        this(new File(parent, child));
    }

    public ZipFileInputStreamImpl(String pathname) throws ZipException, FileNotFoundException, IOException {
        this(new File(pathname));
    }

    public ZipFileInputStreamImpl(URI uri) throws ZipException, FileNotFoundException, IOException {
        this(new File(uri));
    }

    public ZipFileInputStreamImpl(File aFile) throws ZipException, FileNotFoundException, IOException {
        super(ZipFileInputStreamImpl.toInputStream(aFile));
    }

    protected static InputStream toInputStream(File aFile) throws ZipException, IOException, FileNotFoundException {
        return ZipFileUtility.toInputStream(aFile);
    }

    protected static String toFileNameFromZip(String aZipFileName) {
        return ZipFileUtility.toFileNameFromZip(aZipFileName);
    }

    private static class ZipFileUtility
    extends CsvFileRecordsImpl {
        private ZipFileUtility(Header aHeader, File aCsvFile) throws FileNotFoundException, IOException, ZipException {
            super(aHeader, aCsvFile);
        }

        protected static InputStream toInputStream(File aFile) throws ZipException, IOException, FileNotFoundException {
            return CsvFileRecordsImpl.toInputStream((File)aFile);
        }

        protected static String toFileNameFromZip(String aZipFileName) {
            return CsvFileRecordsImpl.toFileNameFromZip((String)aZipFileName);
        }
    }
}

