// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.Serializable;

/**
 * The {@link DatagramReceiver} is used to receive datagrams in a unified way.
 * The {@link #readDatagram()} method provides the next available datagram from
 * the counterpart {@link DatagramSender}; in case there is none available, then
 * this method halts until one is available or the {@link DatagramReceiver} is
 * being shut down or the underlying connection is closed. The
 * {@link #hasDatagram()} method returns true in case a next datagram can be
 * fetched via the {@link #readDatagram()} method from the
 * {@link DatagramReceiver} counterpart.
 *
 * @param <DATA> The type of the datagram to be operated with. In case you wish
 *        to use array types, you might better use the {@link BlockReceiver}
 *        type.
 */
public interface DatagramReceiver<DATA extends Serializable> extends DatagramProvider<DATA>, Receivable {}
