/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.refcodes.component.OpenException;
import org.refcodes.controlflow.RetryCounterImpl;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.io.ByteProvider;
import org.refcodes.mixin.Loggable;

public abstract class AbstractByteProvider
implements ByteProvider,
Loggable {
    public static final int DATAGRAM_QUEUE_SIZE = 1024;
    protected LinkedBlockingQueue<Byte> _datagramQueue;

    public AbstractByteProvider() {
        this._datagramQueue = new LinkedBlockingQueue(1024);
    }

    public AbstractByteProvider(int aCapacity) {
        this._datagramQueue = aCapacity == 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(aCapacity);
    }

    @Override
    public byte readDatagram() throws OpenException, InterruptedException {
        return this._datagramQueue.take();
    }

    @Override
    public byte[] readDatagrams() throws OpenException, InterruptedException {
        ArrayList theBytes = new ArrayList();
        this._datagramQueue.drainTo(theBytes);
        byte[] theDatagrams = new byte[theBytes.size()];
        for (int i = 0; i < theDatagrams.length; ++i) {
            theDatagrams[i] = (Byte)theBytes.get(i);
        }
        return theDatagrams;
    }

    @Override
    public byte[] readDatagrams(int aBlockSize) throws OpenException, InterruptedException {
        ArrayList theBytes = new ArrayList();
        this._datagramQueue.drainTo(theBytes, aBlockSize);
        byte[] theDatagrams = new byte[theBytes.size()];
        for (int i = 0; i < theDatagrams.length; ++i) {
            theDatagrams[i] = (Byte)theBytes.get(i);
        }
        return theDatagrams;
    }

    protected void pushDatagram(byte aDatagram) throws OpenException {
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(IoRetryCount.MAX.getNumber());
        try {
            while (!this._datagramQueue.offer(aDatagram, LoopSleepTime.MAX.getMilliseconds(), TimeUnit.MILLISECONDS) && theRetryCounter.nextRetry()) {
                this.warn("Trying to offer (add) a datagram to the datagram queue, though the queue is full, this is retry # <" + theRetryCounter.getRetryCount() + ">, aborting after <" + theRetryCounter.getRetryNumber() + "> retries. Retrying now after a delay of <" + LoopSleepTime.MAX.getMilliseconds() / 1000 + "> seconds...");
                if (theRetryCounter.hasNextRetry()) continue;
                throw new OpenException("Unable to process the datagram after <" + theRetryCounter.getRetryNumber() + "> retries, aborting retries, dismissing datagram \"" + aDatagram + "\"!", null, null);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void pushDatagrams(byte[] aDatagrams) throws OpenException {
        for (byte eData : aDatagrams) {
            this.pushDatagram(eData);
        }
    }

    protected void pushDatagrams(byte[] aDatagrams, int aOffset, int aLength) throws OpenException {
        for (int i = aOffset; i < aOffset + aLength; ++i) {
            this.pushDatagram(aDatagrams[i]);
        }
    }
}

