/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.controlflow.RetryCounterImpl;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.io.Receiver;
import org.refcodes.mixin.Loggable;

public abstract class AbstractReceiver<DATA extends Serializable>
extends AbstractConnectableAutomaton
implements Receiver<DATA>,
Loggable {
    public static final int DATAGRAM_QUEUE_SIZE = 1024;
    private LinkedBlockingQueue<DATA> _datagramQueue;

    public AbstractReceiver() {
        this._datagramQueue = new LinkedBlockingQueue(1024);
    }

    public AbstractReceiver(int aCapacity) {
        this._datagramQueue = new LinkedBlockingQueue(aCapacity);
    }

    @Override
    public DATA readDatagram() throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        return (DATA)((Serializable)this._datagramQueue.take());
    }

    @Override
    public DATA[] readDatagrams() throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        ArrayList theBytes = new ArrayList();
        this._datagramQueue.drainTo(theBytes);
        return theBytes.toArray((Serializable[])new Object[theBytes.size()]);
    }

    @Override
    public boolean hasDatagram() throws OpenException {
        return !this._datagramQueue.isEmpty();
    }

    public void close() throws CloseException {
        if (this.isOpened()) {
            super.close();
            this.releaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        LinkedBlockingQueue<DATA> linkedBlockingQueue = this._datagramQueue;
        synchronized (linkedBlockingQueue) {
            this._datagramQueue.notifyAll();
        }
    }

    protected void pushDatagram(DATA aDatagram) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to push datagram <" + aDatagram.getClass().getName() + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(IoRetryCount.MAX.getNumber());
        try {
            while (!this._datagramQueue.offer(aDatagram, LoopSleepTime.MAX.getMilliseconds(), TimeUnit.MILLISECONDS) && theRetryCounter.nextRetry()) {
                this.warn("Trying to offer (add) a datagram to the datagram queue, though the queue is full, this is retry # <" + theRetryCounter.getRetryCount() + ">, aborting after <" + theRetryCounter.getRetryNumber() + "> retries. Retrying now after a delay of <" + LoopSleepTime.MAX.getMilliseconds() / 1000 + "> seconds...");
                if (theRetryCounter.hasNextRetry()) continue;
                throw new OpenException("Unable to process the datagram after <" + theRetryCounter.getRetryNumber() + "> retries, aborting retries, dismissing datagram \"" + aDatagram.toString() + "\"!", null, null);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void pushDatagrams(DATA[] aDatagrams) throws OpenException {
        for (DATA eData : aDatagrams) {
            this.pushDatagram(eData);
        }
    }

    protected void pushDatagrams(DATA[] aDatagrams, int aOffset, int aLength) throws OpenException {
        for (int i = aOffset; i < aOffset + aLength; ++i) {
            this.pushDatagram(aDatagrams[i]);
        }
    }
}

