/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Delimiter;
import org.refcodes.io.FileUtility;
import org.refcodes.textual.CsvBuilderImpl;
import org.refcodes.textual.CsvEscapeMode;

public class FileUtilityTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void toJarHierarchy() throws MalformedURLException {
        URL theJarPath1 = new URL("jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml");
        URL theJarPath2 = new URL("jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/lib/fightclub-adapter-web-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml");
        String[] theJarHierarchy = FileUtility.toJarHierarchy((URL)theJarPath1);
        String theJarPath = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(theJarHierarchy).withDelimiter(Delimiter.PATH.getChar()).toRecord();
        if (IS_LOG_TESTS) {
            System.out.println("JAR parh 1 := " + theJarPath);
        }
        Assertions.assertEquals((Object)"fightclub-app-0.0.1-SNAPSHOT.jar", (Object)theJarPath);
        theJarHierarchy = FileUtility.toJarHierarchy((URL)theJarPath2);
        theJarPath = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(theJarHierarchy).withDelimiter(Delimiter.PATH.getChar()).toRecord();
        if (IS_LOG_TESTS) {
            System.out.println("JAR parh 2 := " + theJarPath);
        }
        Assertions.assertEquals((Object)"fightclub-app-0.0.1-SNAPSHOT.jar/fightclub-adapter-web-0.0.1-SNAPSHOT.jar", (Object)theJarPath);
    }
}

