// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.ChannelAccessor;
import org.refcodes.mixin.GroupAccessor;
import org.refcodes.mixin.UniversalIdAccessor;

/**
 * The Meta-Data describes the event which a publisher posts via the event bus
 * to an event subscriber's event listener. The Meta-Data is the criteria most
 * commonly used by an event matcher in order to identify an loosely coupled
 * event.
 */
public interface EventMetaData extends UniversalIdAccessor, AliasAccessor, GroupAccessor, ChannelAccessor {

	/**
	 * The least common denominator in event Meta-Data is the type of the
	 * publisher which gives a hint on the source of the event.
	 * 
	 * @return The type of the publisher who published the event.
	 */
	Class<?> getPublisherType();

	public interface EventMetaDataBuilder extends EventMetaData, UniversalIdProperty, UniversalIdBuilder<EventMetaDataBuilder>, AliasProperty, AliasBuilder<EventMetaDataBuilder>, GroupProperty, GroupBuilder<EventMetaDataBuilder>, ChannelProperty, ChannelBuilder<EventMetaDataBuilder> {

		/**
		 * The least common denominator in event Meta-Data is the type of the
		 * publisher which gives a hint on the source of the event.
		 * 
		 * @param aPublisherType The type of the publisher who published the
		 *        event.
		 */
		void setPublisherType( Class<?> aPublisherType );

		/**
		 * The least common denominator in event Meta-Data is the type of the
		 * publisher which gives a hint on the source of the event.
		 * 
		 * @param aPublisherType The type of the publisher who published the
		 *        event.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		default EventMetaDataBuilder withPublisherType( Class<?> aPublisherType ) {
			setPublisherType( aPublisherType );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default EventMetaDataBuilder withChannel( String aChannel ) {
			setChannel( aChannel );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default EventMetaDataBuilder withGroup( String aGroup ) {
			setGroup( aGroup );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default EventMetaDataBuilder withAlias( String aAlias ) {
			setAlias( aAlias );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default EventMetaDataBuilder withUniversalId( String aUid ) {
			setUniversalId( aUid );
			return this;
		}
	}
}
