/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import org.refcodes.matcher.Matcher;
import org.refcodes.matcher.MatcherSugar;
import org.refcodes.observer.EventMatcher;
import org.refcodes.observer.EventMetaData;
import org.refcodes.observer.GenericActionMetaDataEvent;
import org.refcodes.observer.GenericMetaDataEvent;

public class EventMatcherSugar {
    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> catchAll() {
        return new EventMatcher<E>(){

            @Override
            public boolean isMatching(E aEvent) {
                return true;
            }
        };
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> catchNone() {
        return new EventMatcher<E>(){

            @Override
            public boolean isMatching(E aEvent) {
                return false;
            }
        };
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> isAssignableFrom(Class<?> aEventType) {
        Matcher theAssignableFrom = MatcherSugar.isAssignableFrom(aEventType);
        return new EventMatcherWrapper(theAssignableFrom);
    }

    public static <E extends GenericMetaDataEvent<?, ?>, PT> EventMatcher<E> publisherIsAssignableFrom(Class<? extends PT> aPublisherType) {
        return new PublisherIsAssignableFromMatcherImpl(aPublisherType);
    }

    @SafeVarargs
    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> or(EventMatcher<E> ... aEventMatchers) {
        return new EventMatcherWrapper(MatcherSugar.or((Matcher[])aEventMatchers));
    }

    @SafeVarargs
    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> and(EventMatcher<E> ... aEventMatchers) {
        return new EventMatcherWrapper(MatcherSugar.and((Matcher[])aEventMatchers));
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> nameEqualWith(String aAlias) {
        return new AliasEqualWithMatcherImpl(aAlias);
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> groupEqualWith(String aGroup) {
        return new GroupEqualWithMatcherImpl(aGroup);
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> universalIdEqualWith(String aUid) {
        return new UniversalIdEqualWithMatcherImpl(aUid);
    }

    public static <E extends GenericActionMetaDataEvent<A, ?, ?>, A> EventMatcher<E> actionEqualWith(A aAction) {
        return new ActionEqualWithMatcherImpl(aAction);
    }

    private static class ActionEqualWithMatcherImpl<E extends GenericActionMetaDataEvent<?, ?, ?>>
    implements EventMatcher<E> {
        private Object _action;

        public <A> ActionEqualWithMatcherImpl(A aAction) {
            this._action = aAction;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            if (this._action != null) {
                return this._action.equals(aEvent.getAction());
            }
            return aEvent.getAction() == null;
        }
    }

    private static class UniversalIdEqualWithMatcherImpl<E extends GenericMetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private String _universalId;

        public UniversalIdEqualWithMatcherImpl(String aUid) {
            this._universalId = aUid;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            if (this._universalId != null) {
                return this._universalId.equals(((EventMetaData)aEvent.getMetaData()).getUniversalId());
            }
            return ((EventMetaData)aEvent.getMetaData()).getUniversalId() == null;
        }
    }

    private static class GroupEqualWithMatcherImpl<E extends GenericMetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private String _group;

        public GroupEqualWithMatcherImpl(String aGroup) {
            this._group = aGroup;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            if (this._group != null) {
                return this._group.equals(((EventMetaData)aEvent.getMetaData()).getGroup());
            }
            return ((EventMetaData)aEvent.getMetaData()).getGroup() == null;
        }
    }

    private static class AliasEqualWithMatcherImpl<E extends GenericMetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private String _alias;

        public AliasEqualWithMatcherImpl(String aAlias) {
            this._alias = aAlias;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            if (this._alias != null) {
                return this._alias.equals(((EventMetaData)aEvent.getMetaData()).getAlias());
            }
            return ((EventMetaData)aEvent.getMetaData()).getAlias() == null;
        }
    }

    private static class PublisherIsAssignableFromMatcherImpl<E extends GenericMetaDataEvent<?, ?>, PT>
    implements EventMatcher<E> {
        private Class<? extends PT> _eventPublisherType;

        public PublisherIsAssignableFromMatcherImpl(Class<? extends PT> aEventPublisherType) {
            this._eventPublisherType = aEventPublisherType;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            return this._eventPublisherType == null || ((EventMetaData)aEvent.getMetaData()).getPublisherType().isAssignableFrom(this._eventPublisherType);
        }
    }

    private static class EventMatcherWrapper<E extends GenericMetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private Matcher<E> _eventMatcher;

        public EventMatcherWrapper(Matcher<E> aMatcher) {
            assert (aMatcher != null);
            this._eventMatcher = aMatcher;
        }

        @Override
        public boolean isMatching(E aEvent) {
            return this._eventMatcher.isMatching(aEvent);
        }
    }
}

