package org.refcodes.rest.ext.eureka;

import org.refcodes.net.HttpBodyMap;

public interface AmazonMetaData extends HttpBodyMap {

	default void setAmiLaunchIndex( Integer aValue ) {
		putInteger( "/ami-launch-index", aValue );
	}

	default void setLocalHostName( String aValue ) {
		put( "/local-hostname", aValue );
	}

	default void setAvailabilityZone( String aValue ) {
		put( "/availability-zone", aValue );
	}

	default void setInstanceId( String aValue ) {
		put( "/instance-id", aValue );
	}

	default void setPublicIpv4( String aValue ) {
		put( "/public-ipv4", aValue );
	}

	default void setPublicHostname( String aValue ) {
		put( "/public-hostname", aValue );
	}

	default void setAmiManifestPath( String aValue ) {
		put( "/ami-manifest-path", aValue );
	}

	default void setLocalIpv4( String aValue ) {
		put( "/local-ipv4", aValue );
	}

	default void setHostname( String aValue ) {
		put( "/hostname", aValue );
	}

	default void setAmiId( String aValue ) {
		put( "/ami-id", aValue );
	}

	default void setInstanceType( String aValue ) {
		put( "/instance-type", aValue );
	}

	default Integer getAmiLaunchIndex() {
		return getInteger( "/ami-launch-index" );
	}

	default String getLocalHostName() {
		return get( "/local-hostname" );
	}

	default String getAvailabilityZone() {
		return get( "/availability-zone" );
	}

	default String getInstanceId() {
		return get( "/instance-id" );
	}

	default String getPublicIpv4() {
		return get( "/public-ipv4" );
	}

	default String getPublicHostname() {
		return get( "/public-hostname" );
	}

	default String getAmiManifestPath() {
		return get( "/ami-manifest-path" );
	}

	default String getLocalIpv4() {
		return get( "/local-ipv4" );
	}

	default String getHostname() {
		return get( "/hostname" );
	}

	default String getAmiId() {
		return get( "/ami-id" );
	}

	default String getInstanceType() {
		return get( "/instance-type" );
	}
}