package org.refcodes.rest.ext.eureka;

import java.net.MalformedURLException;
import java.util.Map;

import org.refcodes.exception.BugException;
import org.refcodes.mixin.AliasAccessor.AliasProperty;
import org.refcodes.mixin.PortAccessor.PortProperty;
import org.refcodes.net.HostAccessor.HostProperty;
import org.refcodes.net.HttpBodyMap;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor.IpAddressProperty;
import org.refcodes.net.Url;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.HomeUrlAccessor.HomeUrlProperty;
import org.refcodes.rest.PingUrlAccessor.PingUrlProperty;
import org.refcodes.rest.StatusUrlAccessor.StatusUrlProperty;

public interface EurekaInstanceDescriptor extends AliasProperty, PingUrlProperty, StatusUrlProperty, HomeUrlProperty, HostProperty, IpAddressProperty, HttpBodyMap, PortProperty {

	default String getActionType() {
		return get( "/actionType" );
	}

	default void setActionType( String aValue ) {
		put( "/actionType", aValue );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default String getAlias() {
		return get( "/app" );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void setAlias( String aAlias ) {
		put( "/app", aAlias );
	}

	default String getCountryId() {
		return get( "/countryId" );
	}

	default void setCountryId( String aValue ) {
		put( "/countryId", aValue );
	}

	default String getDataCenterInfoClass() {
		return get( "/dataCenterInfo/@class" );
	}

	default void setDataCenterInfoClass( String aValue ) {
		put( "/dataCenterInfo/@class", aValue );
	}

	default String getDataCenterInfoName() {
		return get( "/dataCenterInfo/name" );
	}

	default void setDataCenterInfoName( String aValue ) {
		put( "/dataCenterInfo/name", aValue );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default Url getPingUrl() {
		String theHealthCheckUrl = get( "/healthCheckUrl" );
		if ( theHealthCheckUrl == null ) {
			return null;
		}
		try {
			return new UrlImpl( theHealthCheckUrl );
		}
		catch ( MalformedURLException e ) {
			throw new BugException( "Cannot parse the Health-Check URL <" + theHealthCheckUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), e );
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void setPingUrl( Url aUrl ) {
		put( "/healthCheckUrl", aUrl.toHttpUrl() );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default Url getStatusUrl() {
		String theStatusPageUrl = get( "/statusPageUrl" );
		if ( theStatusPageUrl == null ) {
			return null;
		}
		try {
			return new UrlImpl( theStatusPageUrl );
		}
		catch ( MalformedURLException e ) {
			throw new BugException( "Cannot parse the Health-Check URL <" + theStatusPageUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), e );
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void setStatusUrl( Url aUrl ) {
		put( "/statusPageUrl", aUrl.toHttpUrl() );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default Url getHomeUrl() {
		String theHomePageUrl = get( "/homePageUrl" );
		if ( theHomePageUrl == null ) {
			return null;
		}
		try {
			return new UrlImpl( theHomePageUrl );
		}
		catch ( MalformedURLException e ) {
			throw new BugException( "Cannot parse the Health-Check URL <" + theHomePageUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), e );
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void setHomeUrl( Url aUrl ) {
		put( "/homePageUrl", aUrl.toHttpUrl() );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default String getHost() {
		return get( "/hostName" );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void setHost( String aHost ) {
		put( "/hostName", aHost );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default int[] getIpAddress() {
		return IpAddress.fromAnyCidrNotation( get( "/ipAddr" ) );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void setIpAddress( int[] aIpAddress ) {
		put( "/ipAddr", IpAddress.toString( aIpAddress ) );
	}

	default String isCoordinatingDiscoveryServer() {
		return get( "/isCoordinatingDiscoveryServer" );
	}

	default void setCoordinatingDiscoveryServer( String aValue ) {
		put( "/isCoordinatingDiscoveryServer", aValue );
	}

	default Long getLastDirtyTimestamp() {
		return getLong( "/lastDirtyTimestamp" );
	}

	default void setLastDirtyTimestamp( Long aValue ) {
		putLong( "/lastDirtyTimestamp", aValue );
	}

	default Long getLastUpdatedTimestamp() {
		return getLong( "/lastUpdatedTimestamp" );
	}

	default void setLastUpdatedTimestamp( Long aValue ) {
		putLong( "/lastUpdatedTimestamp", aValue );
	}

	default Integer getLeaseInfoDurationInSecs() {
		return getInteger( "/leaseInfo/durationInSecs" );
	}

	default void setLeaseInfoDurationInSecs( Integer aValue ) {
		putInteger( "/leaseInfo/durationInSecs", aValue );
	}

	default Long getLeaseInfoEvictionTimestamp() {
		return getLong( "/leaseInfo/evictionTimestamp" );
	}

	default void setLeaseInfoEvictionTimestamp( Long aValue ) {
		putLong( "/leaseInfo/evictionTimestamp", aValue );
	}

	default Long getLeaseInfoLastRenewalTimestamp() {
		return getLong( "/leaseInfo/lastRenewalTimestamp" );
	}

	default void setLeaseInfoLastRenewalTimestamp( Long aValue ) {
		putLong( "/leaseInfo/lastRenewalTimestamp", aValue );
	}

	default Long getLeaseInfoRegistrationTimestamp() {
		return getLong( "/leaseInfo/registrationTimestamp" );
	}

	default void setLeaseInfoRegistrationTimestamp( Long aValue ) {
		putLong( "/leaseInfo/registrationTimestamp", aValue );
	}

	default Integer getLeaseInfoRenewalIntervalInSecs() {
		return getInteger( "/leaseInfo/renewalIntervalInSecs" );
	}

	default void setLeaseInfoRenewalIntervalInSecs( Integer aValue ) {
		putInteger( "/leaseInfo/renewalIntervalInSecs", aValue );
	}

	default Long getLeaseInfoServiceUpTimestamp() {
		return getLong( "/leaseInfo/serviceUpTimestamp" );
	}

	default void setLeaseInfoServiceUpTimestamp( Long aValue ) {
		putLong( "/leaseInfo/serviceUpTimestamp", aValue );
	}

	default String getMetadataClass() {
		return get( "/metadata/@class" );
	}

	default void setMetadataClass( String aValue ) {
		put( "/metadata/@class", aValue );
	}

	default String getOverriddenstatus() {
		return get( "/overriddenstatus" );
	}

	default void setOverriddenstatus( String aValue ) {
		put( "/overriddenstatus", aValue );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default int getPort() {
		Integer thePort = getInteger( "/port/$" );
		return thePort != null ? thePort : -1;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void setPort( int aPort ) {
		putInteger( "/port/$", aPort );
	}

	default String getPortEnabled() {
		return get( "/port/@enabled" );
	}

	default void setPortEnabled( String aValue ) {
		put( "/port/@enabled", aValue );
	}

	default Integer getSecurePort() {
		return getInteger( "/securePort/$" );
	}

	default void setSecurePort( Integer aValue ) {
		putInteger( "/securePort/$", aValue );
	}

	default String getSecurePortEnabled() {
		return get( "/securePort/@enabled" );
	}

	default void setSecurePortEnabled( String aValue ) {
		put( "/securePort/@enabled", aValue );
	}

	default String getStatus() {
		return get( "/status" );
	}

	default void setStatus( String aValue ) {
		put( "/status", aValue );
	}

	default String getVipAddress() {
		return get( "/vipAddress" );
	}

	default void setVipAddress( String aValue ) {
		put( "/vipAddress", aValue );
	}

	default Map<String, String> getMetaData() {
		return childrenOf( "/metadata" );
	}

	default void setMetaData( Map<String, String> aMetaData ) {
		for ( String eKey : aMetaData.keySet() ) {
			put( toPath( "/metadata", eKey ), aMetaData.get( eKey ) );
		}
	}

	default String putMetaData( String aKey, String aValue ) {
		return put( toPath( "/metadata", aKey ), aValue );
	}
}