package org.refcodes.rest.ext.eureka;

import org.refcodes.data.Delimiter;
import org.refcodes.net.HttpBodyMapImpl;

public class EurekaInstanceDescriptorImpl extends HttpBodyMapImpl implements EurekaInstanceDescriptor {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Create an empty {@link EurekaInstanceDescriptor} instance using the
	 * default path delimiter "/" ({@link Delimiter#PATH}) for the path
	 * declarations.
	 */
	public EurekaInstanceDescriptorImpl() {
		super();
	}

	/**
	 * Creates a {@link EurekaInstanceDescriptor} instance containing the
	 * elements as of {@link MutablePathMap#insert(Object)} using the default
	 * path delimiter "/" ({@link Delimiter#PATH}) for the path declarations.
	 *
	 * @param aObj The object from which the elements are to be added.
	 * 
	 * @param aFromPath The path from where to start adding elements of the
	 *        provided object.
	 */
	public EurekaInstanceDescriptorImpl( Object aObj, String aFromPath ) {
		super( aObj, aFromPath );
	}

	/**
	 * Create a {@link EurekaInstanceDescriptor} instance containing the
	 * elements as of {@link MutablePathMap#insert(Object)} using the default
	 * path delimiter "/" ({@link Delimiter#PATH}) for the path declarations.
	 *
	 * @param aObj The object from which the elements are to be added.
	 */
	public EurekaInstanceDescriptorImpl( Object aObj ) {
		super( aObj );
	}

	/**
	 * Creates a {@link EurekaInstanceDescriptor} instance containing the
	 * elements as of {@link MutablePathMap#insert(Object)} using the default
	 * path delimiter "/" ({@link Delimiter#PATH} for the path declarations.
	 *
	 * @param aToPath The sub-path where to insert the object's introspected
	 *        values to.
	 * 
	 * @param aObj The object from which the elements are to be added.
	 * 
	 * @param aFromPath The path from where to start adding elements of the
	 *        provided object.
	 */
	public EurekaInstanceDescriptorImpl( String aToPath, Object aObj, String aFromPath ) {
		super( aToPath, aObj, aFromPath );
	}

	/**
	 * Create a {@link EurekaInstanceDescriptor} instance containing the
	 * elements as of {@link MutablePathMap#insert(Object)} using the default
	 * path delimiter "/" ({@link Delimiter#PATH}) for the path declarations.
	 *
	 * @param aToPath The sub-path where to insert the object's introspected
	 *        values to.
	 * 
	 * @param aObj The object from which the elements are to be added.
	 */
	public EurekaInstanceDescriptorImpl( String aToPath, Object aObj ) {
		super( aToPath, aObj );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}