// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest.ext.eureka;

import org.refcodes.rest.HomeRequestObserverAccessor;
import org.refcodes.rest.HttpRegistryContext;
import org.refcodes.rest.RestRequestObserver;
import org.refcodes.rest.StatusRequestObserverAccessor;

/**
 * This context describes all information required to register a server
 * ("service") at a Eureka service discovery registry. It specializes the
 * {@link HttpRegistryContext}.
 */
public interface EurekaRegistryContext extends HttpRegistryContext<EurekaServerDescriptor>, StatusRequestObserverAccessor, HomeRequestObserverAccessor {

	/**
	 * The {@link EurekaRegistryContextBuilder} interface extends the
	 * {@link EurekaRegistryContext} with builder functionality as of the
	 * builder pattern.
	 */
	public interface EurekaRegistryContextBuilder extends EurekaRegistryContext, HttpRegistryContextBuilder<EurekaServerDescriptor>, StatusRequestObserverProperty, StatusRequestObserverBuilder<EurekaRegistryContextBuilder>, HomeRequestObserverProperty, HomeRequestObserverBuilder<EurekaRegistryContextBuilder> {

		/**
		 * {@inheritDoc}
		 */
		@Override
		default EurekaRegistryContextBuilder withHomeRequestObserver( RestRequestObserver aRequestObserver ) {
			setHomeRequestObserver( aRequestObserver );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default EurekaRegistryContextBuilder withStatusRequestObserver( RestRequestObserver aRequestObserver ) {
			setStatusRequestObserver( aRequestObserver );
			return this;
		}
	}
}