// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest.ext.eureka;

import org.refcodes.net.Url;
import org.refcodes.rest.HttpRegistryContext;
import org.refcodes.rest.RestRequestObserver;
import org.refcodes.rest.ext.eureka.EurekaRegistryContext.EurekaRegistryContextBuilder;
import org.refcodes.security.TrustStoreDescriptor;

/**
 * Implementation of the {@link EurekaRegistryContextBuilder} representing a
 * waschechten {@link EurekaRegistryContext} being a specialization of the
 * {@link HttpRegistryContext}.
 */
public class EurekaRegistryContextBuilderImpl implements EurekaRegistryContextBuilder {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Url _registryUrl;
	private EurekaServerDescriptor _serverDescriptor;
	private RestRequestObserver _homeRequestObserver;
	private RestRequestObserver _pingRequestObserver;
	private RestRequestObserver _statusRequestObserver;
	private TrustStoreDescriptor _storeDescriptor;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs an {@link EurekaRegistryContextBuilder} instance.
	 */
	public EurekaRegistryContextBuilderImpl() {}

	/**
	 * Constructs an {@link EurekaRegistryContextBuilder} instance.
	 * 
	 * @param aServerDescriptor The descriptor describing the server.
	 * @param aRegistryUrl The {@link Url} pointing to the registry service.
	 * @param aPingRequestObserver The ping (health) request observer.
	 * @param aStatusRequestObserver The status(-page) observer.
	 * @param aHomeRequestObserver The home(-page) observer.
	 * @param aStoreDescriptor The trust store descriptor describing the trust
	 *        store to be used when requesting the registry service.
	 */
	public EurekaRegistryContextBuilderImpl( EurekaServerDescriptor aServerDescriptor, Url aRegistryUrl, RestRequestObserver aPingRequestObserver, RestRequestObserver aStatusRequestObserver, RestRequestObserver aHomeRequestObserver, TrustStoreDescriptor aStoreDescriptor ) {
		_serverDescriptor = aServerDescriptor;
		_registryUrl = aRegistryUrl;
		_homeRequestObserver = aHomeRequestObserver;
		_pingRequestObserver = aPingRequestObserver;
		_statusRequestObserver = aStatusRequestObserver;
		_storeDescriptor = aStoreDescriptor;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestRequestObserver getHomeRequestObserver() {
		return _homeRequestObserver;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Url getHttpRegistryUrl() {
		return _registryUrl;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public EurekaServerDescriptor getHttpServerDescriptor() {
		return _serverDescriptor;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestRequestObserver getPingRequestObserver() {
		return _pingRequestObserver;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RestRequestObserver getStatusRequestObserver() {
		return _statusRequestObserver;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TrustStoreDescriptor getTrustStoreDescriptor() {
		return _storeDescriptor;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setHomeRequestObserver( RestRequestObserver aHomeRequestObserver ) {
		_homeRequestObserver = aHomeRequestObserver;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setHttpRegistryUrl( Url aRegistryUrl ) {
		_registryUrl = aRegistryUrl;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setHttpServerDescriptor( EurekaServerDescriptor aServerDescriptor ) {
		_serverDescriptor = aServerDescriptor;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPingRequestObserver( RestRequestObserver aPingRequestObserver ) {
		_pingRequestObserver = aPingRequestObserver;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setStatusRequestObserver( RestRequestObserver aStatusRequestObserver ) {
		_statusRequestObserver = aStatusRequestObserver;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTrustStoreDescriptor( TrustStoreDescriptor aStoreDescriptor ) {
		_storeDescriptor = aStoreDescriptor;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
