/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.impls;

import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.junit.Test;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HeaderField;
import org.refcodes.net.MediaType;
import org.refcodes.net.ResponseCookie;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.rest.impls.HttpRestServerImpl;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;
import org.refcodes.time.TimeUnit;

public class HttpRestServerTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

    @Test
    public void testHttpRestServer() throws IOException, UnirestException {
        HttpRestServerImpl theRestServer = new HttpRestServerImpl();
        theRestServer.onGet("/refcodes", aEvent -> {
            LOGGER.debug(aEvent.getAction() + ": " + aEvent.getLocator());
            LOGGER.debug("Header fields: " + new VerboseTextBuilderImpl().withElements((Map)aEvent.getHeaderFields()).toString());
            LOGGER.debug("Cookies: " + new VerboseTextBuilderImpl().withElements((Collection)aEvent.getHeaderFields().getCookies()).toString());
            ResponseHeaderFields theHeaders = aEvent.getResponseHeaderFields();
            ((ResponseCookie)theHeaders.addCookie("token1", "51615161")).withHttpOnly(true).withExpiresAfter(TimeUnit.MINUTE, 5L);
            ((ResponseCookie)theHeaders.addCookie("token2", "66666669")).withSecure(true);
            theHeaders.setContentType(MediaType.APPLICATION_JSON);
            return new Person("Nolan", "Bushnell");
        });
        theRestServer.open((Object)5161);
        Unirest.get((String)"http://localhost:5161/refcodes").header(HeaderField.ACCEPT.getName(), MediaType.APPLICATION_JSON.toHttpMediaType()).asJson();
        theRestServer.close();
    }

    public static class Person {
        private String firstName;
        private String lastName;

        public String toString() {
            return "Person [firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
        }

        public Person() {
        }

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

