/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.impls;

import org.junit.Assert;
import org.junit.Test;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HeaderField;
import org.refcodes.net.HttpException;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerResponse;
import org.refcodes.net.MediaType;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.ResponseCookie;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.net.impls.RequestHeaderFieldsImpl;
import org.refcodes.rest.impls.LoopbackRestService;
import org.refcodes.time.TimeUnit;

public class RestServiceTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

    @Test
    public void testRestService() throws HttpException {
        LoopbackRestService theRestService = new LoopbackRestService();
        theRestService.subscribeObserver(HttpMethod.GET, "/refcodes", aEvent -> {
            LOGGER.debug(aEvent.getAction() + ": " + aEvent.getLocator());
            Person thePerson = (Person)aEvent.getRequest(Person.class);
            ResponseHeaderFields theHeaders = aEvent.getResponseHeaderFields();
            ((ResponseCookie)theHeaders.addCookie("token1", "51615161")).withHttpOnly(true).withExpiresAfter(TimeUnit.MINUTE, 5L);
            ((ResponseCookie)theHeaders.addCookie("token2", "66666669")).withSecure(true);
            return thePerson;
        });
        RequestHeaderFieldsImpl theHeaderFields = new RequestHeaderFieldsImpl();
        theHeaderFields.set(HeaderField.USER_AGENT, "Loopback");
        theHeaderFields.setContentType(MediaType.APPLICATION_JSON);
        String theBody = "{\"firstName\":\"Nolan\",\"lastName\":\"Bushnell\"}";
        HttpServerResponse theResponse = theRestService.onHttpRequest(HttpMethod.GET, "/refcodes", null, (RequestHeaderFields)theHeaderFields, theBody);
        Assert.assertEquals((Object)((Person)theResponse.getResponse()).getFirstName(), (Object)"Nolan");
        Assert.assertEquals((Object)((Person)theResponse.getResponse()).getLastName(), (Object)"Bushnell");
    }

    public static class Person {
        private String firstName;
        private String lastName;

        public String toString() {
            return "Person [firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
        }

        public Person() {
        }

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

