// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest.impls;

import org.refcodes.net.FormFields;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.impls.HttpClientRequestImpl;
import org.refcodes.rest.RestCallerBuilder;
import org.refcodes.rest.RestClient;
import org.refcodes.rest.RestRequestBuilder;
import org.refcodes.rest.RestResponse;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;

/**
 * The implementation of the {@link RestCallerBuilder} interface as good old
 * POJO for use by different {@link RestClient} implementations.
 */
public class RestRequestBuilderImpl extends HttpClientRequestImpl implements RestRequestBuilder {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private RestClient _restClient;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new rest request builder impl.
	 *
	 * @param aHttpMethod the a http method
	 * @param aLocator the a locator
	 * @param aQueryFields the a query fields
	 * @param aHeaderFields the a Header-Fields
	 * @param aRequest the a request
	 * @param aRestClient the a rest client
	 */
	protected RestRequestBuilderImpl( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest, RestClient aRestClient ) {
		super( aHttpMethod, aLocator, aQueryFields, aHeaderFields, aRequest, aRestClient );
		_restClient = aRestClient;
	}

	/**
	 * Instantiates a new rest request builder impl.
	 *
	 * @param aHttpMethod the a http method
	 * @param aLocator the a locator
	 * @param aQueryFields the a query fields
	 * @param aRestClient the a rest client
	 */
	protected RestRequestBuilderImpl( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, RestClient aRestClient ) {
		this( aHttpMethod, aLocator, aQueryFields, null, null, aRestClient );
	}

	/**
	 * Instantiates a new rest request builder impl.
	 *
	 * @param aHttpMethod the a http method
	 * @param aLocator the a locator
	 * @param aRequest the a request
	 * @param aRestClient the a rest client
	 */
	protected RestRequestBuilderImpl( HttpMethod aHttpMethod, String aLocator, Object aRequest, RestClient aRestClient ) {
		this( aHttpMethod, aLocator, null, null, aRequest, aRestClient );
	}

	/**
	 * Instantiates a new rest request builder impl.
	 *
	 * @param aHttpMethod the a http method
	 * @param aLocator the a locator
	 * @param aQueryFields the a query fields
	 * @param aRequest the a request
	 * @param aRestClient the a rest client
	 */
	protected RestRequestBuilderImpl( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, Object aRequest, RestClient aRestClient ) {
		this( aHttpMethod, aLocator, aQueryFields, null, aRequest, aRestClient );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public String getLocator() {
		return _locator;
	}

	@Override
	public HttpMethod getHttpMethod() {
		return _httpMethod;
	}

	@Override
	public void setLocator( String aLocator ) {
		_locator = aLocator;
	}

	@Override
	public void setHttpMethod( HttpMethod aHttpMethod ) {
		_httpMethod = aHttpMethod;
	}

	@Override
	public void setQueryFields( FormFields aQueryFields ) {
		_queryFields = aQueryFields;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _httpMethod + ": " + _locator + "?" + new VerboseTextBuilderImpl().withElements( _queryFields ).toString() + ")@" + hashCode();
	}

	@Override
	public void setHeaderFields( RequestHeaderFields aHeaderFields ) {
		_headerFields = aHeaderFields;
	}

	@Override
	public RestResponse toRestResponse() throws HttpResponseException {
		return _restClient.doRequest( getHttpMethod(), getLocator(), getQueryFields(), getHeaderFields(), (Object) getRequest() );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
