// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest.impls;

import java.io.InputStream;
import java.net.InetSocketAddress;

import org.refcodes.net.HttpStatusCode;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.rest.RestClient;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseEvent;
import org.refcodes.rest.RestServer;

/**
 * Implementation of the {@link RestResponseEvent} interface as good old POJO
 * for use by different {@link RestClient} implementations.
 */
public class RestResponseEventImpl extends RestResponseImpl implements RestResponseEvent {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs a {@link RestResponseEvent} with all required attributes.
	 * 
	 * @param aRestResponse The response with all the required attributes to be
	 *        used for the event.
	 * @param aRestClient The system firing the event.
	 */
	public RestResponseEventImpl( RestResponse aRestResponse, RestClient aRestClient ) {
		this( aRestResponse.getLocalAddress(), aRestResponse.getRemoteAddress(), aRestResponse.getHttpStatusCode(), aRestResponse.getHeaderFields(), aRestResponse.getHttpInputStream(), aRestClient );
	}

	/**
	 * Constructs a {@link RestResponseEvent} with all required attributes.
	 * 
	 * @param aLocalAddress The local address where the event is being received.
	 * @param aRemoteAddress The remote address from which the request
	 *        originates.
	 * @param aHttpStatusCode The {@link HttpStatusCode} of the response.
	 * @param aHeaderFields The {@link ResponseHeaderFields} sent by the
	 *        response.
	 * @param aHttpInputStream The {@link InputStream} representing the
	 *        request's HTTP body.
	 * @param aRestClient The system firing the event.
	 */
	public RestResponseEventImpl( InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpStatusCode aHttpStatusCode, ResponseHeaderFields aHeaderFields, InputStream aHttpInputStream, RestClient aRestClient ) {
		super( aLocalAddress, aRemoteAddress, aHttpStatusCode, aHeaderFields, aHttpInputStream, aRestClient );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public RestServer getSource() {
		return (RestServer) _mediaTypeFactoryLookup;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
