/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.impls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.refcodes.data.License;
import org.refcodes.io.impls.InputStreamStringBuilderImpl;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.BasicAuthCredentials;
import org.refcodes.net.BasicAuthFailureException;
import org.refcodes.net.BasicAuthRequiredException;
import org.refcodes.net.FormFields;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpStatusCode;
import org.refcodes.net.RequestCookie;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.net.impls.PortManagerSingleton;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.RestCallerBuilder;
import org.refcodes.rest.impls.HttpRestClientImpl;
import org.refcodes.rest.impls.HttpRestServerImpl;

public class HttpRestServerTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String LOCATOR = "/bla";
    private static final String BASE_URL = "http://localhost";
    private static final String BASE_LOCATOR = "/refcodes";
    private static final String COOKIE_A_NAME = "refcodes";
    private static final String COOKIE_A_VALUE = "org";
    private static final String COOKIE_A_VALUE_2 = "com";
    private static final String COOKIE_B_NAME = "funcodes";
    private static final String COOKIE_B_VALUE = "forever";
    private static final String LAST_NAME = "Bushnell";
    private static final String FIRST_NAME = "Nolan";
    private static final String USER_NAME = "nobody";
    private static final String PASSWORD = "secret";
    private static final String KEY_LAST_NAME = "lastName";
    private static final String KEY_FIRST_NAME = "firstName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRestServer() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRestServerAllMethods1() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onRequest(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRestServerAllMethods2() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onRequest(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = new Person(aRequest.getQueryFields().getFirst(KEY_FIRST_NAME), aRequest.getQueryFields().getFirst(KEY_LAST_NAME));
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestCallerBuilder theCaller = theRestClient.doRequest(HttpMethod.GET, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        });
        ((FormFields)theCaller.getQueryFields().withPut(KEY_LAST_NAME, LAST_NAME)).withPut(KEY_FIRST_NAME, FIRST_NAME);
        theCaller.open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRestServerStreamA() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            InputStream theInputStream = (InputStream)aRequest.getRequest(InputStream.class);
            String theHttpBody = new InputStreamStringBuilderImpl().withInputStream(theInputStream).toString();
            Assert.assertEquals((Object)License.REFCODES_LICENSE.getText(), (Object)theHttpBody);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new ByteArrayInputStream(License.REFCODES_LICENSE.getText().getBytes(StandardCharsets.UTF_8))).open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRestServerStreamB() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            InputStream theInputStream = (InputStream)aRequest.getRequest(InputStream.class);
            String theHttpBody = new InputStreamStringBuilderImpl().withInputStream(theInputStream).toString();
            Assert.assertNotEquals((Object)License.REFCODES_LICENSE.getText(), (Object)theHttpBody);
            Assert.assertEquals((Object)License.REFCODES_LICENSE.getText().replaceAll("\\n", "\r\n"), (Object)theHttpBody);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new ByteArrayInputStream(License.REFCODES_LICENSE.getText().replaceAll("\\n", "\r\n").getBytes(StandardCharsets.UTF_8))).open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRestServerStreamC() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            InputStream theInputStream = (InputStream)aRequest.getRequest(InputStream.class);
            String theHttpBody = new InputStreamStringBuilderImpl().withInputStream(theInputStream).toString();
            Assert.assertNotEquals((Object)License.REFCODES_LICENSE.getText(), (Object)theHttpBody);
            Assert.assertEquals((Object)(String.valueOf(License.REFCODES_LICENSE.getText()) + "\n"), (Object)theHttpBody);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new ByteArrayInputStream((String.valueOf(License.REFCODES_LICENSE.getText()) + "\n").getBytes(StandardCharsets.UTF_8))).open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerCookie() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            RequestCookie theCookie = (RequestCookie)((RequestHeaderFields)aRequest.getHeaderFields()).getFirstCookie(COOKIE_A_NAME);
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)theCookie.getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)theCookie.getValue());
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestCallerBuilder theBuilder = theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME));
        ((RequestHeaderFields)theBuilder.getHeaderFields()).addCookie(COOKIE_A_NAME, COOKIE_A_VALUE);
        theBuilder.open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerCookies() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
            List theCookies = ((RequestHeaderFields)aRequest.getHeaderFields()).getAllCookies();
            Assert.assertEquals((String)"Expecting two cookies", (long)2L, (long)theCookies.size());
            int a = 0;
            int b = 1;
            if (((String)((RequestCookie)theCookies.get(a)).getValue()).equals(COOKIE_A_VALUE_2)) {
                a = 1;
                b = 0;
            }
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((RequestCookie)theCookies.get(a)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)((RequestCookie)theCookies.get(a)).getValue());
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((RequestCookie)theCookies.get(b)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE_2, (Object)((RequestCookie)theCookies.get(b)).getValue());
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestCallerBuilder theBuilder = theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME));
        ((RequestHeaderFields)theBuilder.getHeaderFields()).addCookie(COOKIE_A_NAME, COOKIE_A_VALUE);
        ((RequestHeaderFields)theBuilder.getHeaderFields()).addCookie(COOKIE_A_NAME, COOKIE_A_VALUE_2);
        theBuilder.open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllServerCookies() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
            List theCookies = ((RequestHeaderFields)aRequest.getHeaderFields()).getAllCookies();
            Assert.assertEquals((String)"Expecting two cookies", (long)2L, (long)theCookies.size());
            int a = 0;
            int b = 1;
            if (((String)((RequestCookie)theCookies.get(a)).getKey()).equals(COOKIE_B_NAME)) {
                a = 1;
                b = 0;
            }
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((RequestCookie)theCookies.get(a)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)((RequestCookie)theCookies.get(a)).getValue());
            Assert.assertEquals((Object)COOKIE_B_NAME, (Object)((RequestCookie)theCookies.get(b)).getKey());
            Assert.assertEquals((Object)COOKIE_B_VALUE, (Object)((RequestCookie)theCookies.get(b)).getValue());
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestCallerBuilder theBuilder = theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME));
        ((RequestHeaderFields)theBuilder.getHeaderFields()).addCookie(COOKIE_A_NAME, COOKIE_A_VALUE);
        ((RequestHeaderFields)theBuilder.getHeaderFields()).addCookie(COOKIE_B_NAME, COOKIE_B_VALUE);
        theBuilder.open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicAuthSuccess() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onGet(LOCATOR, (aRequest, aResponse) -> {
            BasicAuthCredentials theCredentials = ((RequestHeaderFields)aRequest.getHeaderFields()).getBasicAuthCredentials();
            LOGGER.debug(String.valueOf(theCredentials.toString()) + " := " + theCredentials.toHttpAuthorization());
            Assert.assertEquals((Object)USER_NAME, (Object)theCredentials.getUserName());
            Assert.assertEquals((Object)PASSWORD, (Object)theCredentials.getSecret());
            aResponse.setResponse((Object)"Authentification success!");
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestCallerBuilder theCaller = theRestClient.doRequest(HttpMethod.GET, LOCATOR, aResponse -> {
            Assert.assertEquals((Object)HttpStatusCode.OK, (Object)aResponse.getHttpStatusCode());
            String theMessage = (String)aResponse.getResponse(String.class);
            LOGGER.debug(theMessage);
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        });
        ((RequestHeaderFields)theCaller.getHeaderFields()).putBasicAuthCredentials(USER_NAME, PASSWORD);
        theCaller.open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicAuthFailure() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onGet(LOCATOR, (aRequest, aResponse) -> {
            BasicAuthCredentials theCredentials = ((RequestHeaderFields)aRequest.getHeaderFields()).getBasicAuthCredentials();
            LOGGER.debug(String.valueOf(theCredentials.toString()) + " := " + theCredentials.toHttpAuthorization());
            Assert.assertEquals((Object)USER_NAME, (Object)theCredentials.getUserName());
            Assert.assertEquals((Object)PASSWORD, (Object)theCredentials.getSecret());
            throw new BasicAuthFailureException("Authentification failed!");
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestCallerBuilder theCaller = theRestClient.doRequest(HttpMethod.GET, LOCATOR, aResponse -> {
            Assert.assertEquals((Object)HttpStatusCode.UNAUTHORIZED, (Object)aResponse.getHttpStatusCode());
            String theAuth = ((ResponseHeaderFields)aResponse.getHeaderFields()).getAuthenticate();
            LOGGER.debug("Ahthenticate := " + theAuth);
            String theMessage = aResponse.getHttpBody();
            LOGGER.debug("Error message := " + theMessage);
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        });
        ((RequestHeaderFields)theCaller.getHeaderFields()).putBasicAuthCredentials(USER_NAME, PASSWORD);
        theCaller.open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicAuthRequired() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onGet(LOCATOR, (aRequest, aResponse) -> {
            BasicAuthCredentials theCredentials = ((RequestHeaderFields)aRequest.getHeaderFields()).getBasicAuthCredentials();
            LOGGER.debug(String.valueOf(theCredentials.toString()) + " := " + theCredentials.toHttpAuthorization());
            Assert.assertEquals((Object)USER_NAME, (Object)theCredentials.getUserName());
            Assert.assertEquals((Object)PASSWORD, (Object)theCredentials.getSecret());
            throw new BasicAuthRequiredException("Authentification failed!");
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestCallerBuilder theCaller = theRestClient.doRequest(HttpMethod.GET, LOCATOR, aResponse -> {
            Assert.assertEquals((Object)HttpStatusCode.UNAUTHORIZED, (Object)aResponse.getHttpStatusCode());
            String theAuth = ((ResponseHeaderFields)aResponse.getHeaderFields()).getAuthenticate();
            LOGGER.debug("Ahthenticate := " + theAuth);
            Assert.assertNotNull((Object)theAuth);
            Assert.assertTrue((boolean)theAuth.startsWith("Basic realm"));
            String theMessage = aResponse.getHttpBody();
            LOGGER.debug("Error message := " + theMessage);
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        });
        ((RequestHeaderFields)theCaller.getHeaderFields()).putBasicAuthCredentials(USER_NAME, PASSWORD);
        theCaller.open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryFields() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Assert.assertEquals((Object)FIRST_NAME, (Object)aRequest.getQueryFields().getFirst(KEY_FIRST_NAME));
            Assert.assertEquals((Object)LAST_NAME, (Object)aRequest.getQueryFields().getFirst(KEY_LAST_NAME));
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestCallerBuilder theCaller = theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            theRestServer.closeQuietly();
            HttpRestServerTest httpRestServerTest = this;
            synchronized (httpRestServerTest) {
                this.notifyAll();
            }
        });
        ((FormFields)theCaller.getQueryFields().withAddTo(KEY_FIRST_NAME, FIRST_NAME)).withAddTo(KEY_LAST_NAME, LAST_NAME);
        theCaller.open();
        HttpRestServerTest httpRestServerTest = this;
        synchronized (httpRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    private String toBaseUrl(Integer thePort) {
        return "http://localhost:" + thePort + BASE_LOCATOR;
    }

    public static class Person {
        private String firstName;
        private String lastName;

        public String toString() {
            return "Person [firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
        }

        public Person() {
        }

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

