// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

import java.security.KeyStore;

import org.refcodes.net.LoadBalancingStrategy;
import org.refcodes.net.Url;
import org.refcodes.rest.HttpDiscoveryContext.HttpDiscoveryContextBuilder;
import org.refcodes.security.TrustStoreDescriptor;

/**
 *
 */
public class HttpDiscoveryContextBuilderImpl implements HttpDiscoveryContextBuilder {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Url _discoveryUrl;
	private TrustStoreDescriptor _trustStoreDescriptor;
	private LoadBalancingStrategy _strategy;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs the {@link HttpDiscoveryContextBuilderImpl} context.
	 * 
	 * @param aDiscoveryUrl The {@link Url} pointing to the service discovery
	 *        registry.
	 */
	public HttpDiscoveryContextBuilderImpl( Url aDiscoveryUrl ) {
		this( aDiscoveryUrl, null );
	}

	/**
	 * Constructs the {@link HttpDiscoveryContextBuilderImpl} context.
	 * 
	 * @param aDiscoveryUrl The {@link Url} pointing to the service discovery
	 *        registry.
	 * @param aStoreDescriptor The descriptor describing the truststore
	 *        ({@link KeyStore}) required for establishing an HTTPS connection
	 *        to the registry.
	 */
	public HttpDiscoveryContextBuilderImpl( Url aDiscoveryUrl, TrustStoreDescriptor aStoreDescriptor ) {
		_discoveryUrl = aDiscoveryUrl;
		_trustStoreDescriptor = aStoreDescriptor;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Url getHttpDiscoveryUrl() {
		return _discoveryUrl;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TrustStoreDescriptor getTrustStoreDescriptor() {
		return _trustStoreDescriptor;
	}

	@Override
	public void setHttpDiscoveryUrl( Url aUrl ) {
		_discoveryUrl = aUrl;

	}

	@Override
	public void setTrustStoreDescriptor( TrustStoreDescriptor aStoreDescriptor ) {
		_trustStoreDescriptor = aStoreDescriptor;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public LoadBalancingStrategy getLoadBalancingStrategy() {
		return _strategy;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLoadBalancingStrategy( LoadBalancingStrategy aStrategy ) {
		_strategy = aStrategy;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
