// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

import java.net.MalformedURLException;

import org.refcodes.data.Scheme;
import org.refcodes.net.FormFields;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.Url;

/**
 * Helper class to get the syntactic sugar (from a maintenance point of view)
 * under control. You should actually statically import the
 * {@link HttpRestClientSugar}.
 */
public class RestDeleteClientSugar extends RestPutClientSugar {

	/**
	 * See also {@link HttpRestClient#buildDelete(Scheme, String, int, String)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, int, String, FormFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, int, String, FormFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, int, String, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, int, String, RequestHeaderFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(Scheme, String, String)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, String, FormFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, String, FormFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, String, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, String, RequestHeaderFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 * 
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Scheme, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Scheme aScheme, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aScheme, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestRequestBuilder buildDelete( String aUrl ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().buildDelete( aUrl );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, FormFields)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestRequestBuilder buildDelete( String aLocator, FormFields aQueryFields ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, FormFields, Object)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestRequestBuilder buildDelete( String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestRequestBuilder buildDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestRequestBuilder buildDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, Object)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestRequestBuilder buildDelete( String aUrl, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().buildDelete( aUrl, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, RequestHeaderFields)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestRequestBuilder buildDelete( String aUrl, RequestHeaderFields aHeaderFields ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().buildDelete( aUrl, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestRequestBuilder buildDelete( String aUrl, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().buildDelete( aUrl, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, String, int, String)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, String, String)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(Url)}
	 *
	 * @param aUrl The {@link Url} from which to take the URL specific data.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Url aUrl ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aUrl );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(Url, RequestHeaderFields)}
	 *
	 * @param aUrl The {@link Url} from which to take the URL specific data.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestRequestBuilder} which is used to prepare and
	 *         synchronously issue the request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestRequestBuilder buildDelete( Url aUrl, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aUrl, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(Scheme, String, int, String)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, FormFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, FormFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 * 
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aQueryFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, int aPort, String aPath, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, RequestHeaderFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, int, String, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(Scheme, String, String)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, FormFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, FormFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aQueryFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aQueryFields, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(Scheme, String, String, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, Object, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, String aPath, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, RequestHeaderFields)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( Scheme aScheme, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Scheme, String, String, RestResponseObserver)}
	 *
	 * @param aScheme The {@link Scheme} (e.g. HTTP or HTTPS) to be used for the
	 *        destination URL.
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Scheme aScheme, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aScheme, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( String aUrl ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, FormFields)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( String aLocator, FormFields aQueryFields ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, FormFields, Object)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestCallerBuilder doDelete( String aLocator, FormFields aQueryFields, Object aRequest, RestResponseObserver aResponseObserver ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestCallerBuilder doDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestCallerBuilder doDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RestResponseObserver)}
	 *
	 * @param aLocator The targeted locator, usually the part of the URL till
	 *        (excluding) the query fields and the fragment.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestCallerBuilder doDelete( String aLocator, FormFields aQueryFields, RestResponseObserver aResponseObserver ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, Object)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( String aUrl, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, Object, RestResponseObserver)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCallerBuilder}.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestCallerBuilder doDelete( String aUrl, Object aRequest, RestResponseObserver aResponseObserver ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aRequest, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, RequestHeaderFields)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( String aUrl, RequestHeaderFields aHeaderFields ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, RequestHeaderFields, Object)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( String aUrl, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCallerBuilder}.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestCallerBuilder doDelete( String aUrl, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCallerBuilder}.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestCallerBuilder doDelete( String aUrl, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, RestResponseObserver)}
	 *
	 * @param aUrl The targeted URL locating the addressed resource.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCallerBuilder}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestCallerBuilder doDelete( String aUrl, RestResponseObserver aResponseObserver ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, String, int, String)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPort The port to be used when connecting to the host.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, String, String)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aQueryFields The Query-Fields to be used for the HTTP
	 *        Query-String.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, String, String, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RestResponseObserver)}}
	 *
	 * @param aProtocol The protocol (e.g. HTTP or HTTPS) including the specific
	 *        part (such as "//" for "http://") to be used for the destination
	 *        URL: For HTTP, provide "http://", for HTTPS, provide "https://".
	 *
	 * @param aHost The host to which the destination URL is to point to.
	 *
	 * @param aPath The path on the host to which the base destination URL is to
	 *        point to.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(Url, Object)}
	 *
	 * @param aUrl The {@link Url} from which to take the URL specific data.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @return The {@link RestResponse} as of your request.
	 *
	 * @throws HttpResponseException thrown in case of some unexpected response.
	 *
	 * @throws MalformedURLException in case the provided URL is considered
	 *         being malformed.
	 */
	public static RestResponse doDelete( Url aUrl, Object aRequest ) throws HttpResponseException, MalformedURLException {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Url, Object, RestResponseObserver)}
	 *
	 * @param aUrl The {@link Url} from which to take the URL specific data.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Url aUrl, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aUrl The {@link Url} from which to take the URL specific data.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aRequest The body to be sent with the request (e.g. when doing a
	 *        {@link HttpMethod#DELETE} request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aHeaderFields, aRequest, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Url, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aUrl The {@link Url} from which to take the URL specific data.
	 *
	 * @param aHeaderFields The HTTP-Header's fields to be used for the request.
	 *
	 * @param aResponseObserver The listener processing a response targeted at
	 *        this {@link RestCaller}.
	 *
	 * @return The {@link RestCallerBuilder} which is used by your request.
	 */
	public static RestCallerBuilder doDelete( Url aUrl, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aUrl, aHeaderFields, aResponseObserver );
	}
}
