package org.refcodes.rest;

import org.refcodes.mixin.Dumpable;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpStatusCode;
import org.refcodes.observer.GenericActionEvent;

/**
 * Defines a {@link RestResponseEvent} being the response as consumed by a
 * {@link RestCaller}'s {@link RestResponseObserver}. Usually you will use
 * {@link RestClient#doRequest(HttpMethod, String, RestResponseObserver)} or the
 * like for registering a {@link RestResponseObserver} to the {@link RestClient}
 * ({@link HttpRestClient}).
 */
public interface RestResponseEvent extends GenericActionEvent<HttpStatusCode, RestServer>, RestResponse, Dumpable {

	/**
	 * {@inheritDoc}
	 */
	@Override
	default HttpStatusCode getAction() {
		return getHttpStatusCode();
	}
}
