/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.Text;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.ApplicationFormFactory;
import org.refcodes.net.ApplicationJsonFactory;
import org.refcodes.net.ApplicationXmlFactory;
import org.refcodes.net.HttpClientRequest;
import org.refcodes.net.HttpClientRequestImpl;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.MediaType;
import org.refcodes.net.MediaTypeFactory;
import org.refcodes.net.MediaTypeFactoryLookup;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.net.TextPlainFactory;
import org.refcodes.net.Url;
import org.refcodes.rest.RestCallerBuilder;
import org.refcodes.rest.RestCallerBuilderImpl;
import org.refcodes.rest.RestClient;
import org.refcodes.rest.RestRequestBuilder;
import org.refcodes.rest.RestRequestBuilderImpl;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseEventImpl;
import org.refcodes.rest.RestResponseObserver;
import org.refcodes.runtime.Correlation;
import org.refcodes.textual.VerboseTextBuilderImpl;

public abstract class AbstractRestClient
implements RestClient {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private Map<MediaType, MediaTypeFactory> _mediaTypeFacotries = new LinkedHashMap<MediaType, MediaTypeFactory>();
    private ExecutorService _executorService;
    private String _userAgent = this.getClass().getSimpleName() + "@" + Text.REFCODES_ORG.getText();
    private RestRequestHandler _handler = null;
    protected boolean _hasRequestCorrelation = true;
    protected boolean _hasSessionCorrelation = true;

    public AbstractRestClient(ExecutorService aExecutorService) {
        this._executorService = aExecutorService != null ? aExecutorService : ControlFlowUtility.createCachedExecutorService((boolean)true);
        this.initMedaTypeFactories();
    }

    public AbstractRestClient() {
        this(ControlFlowUtility.createCachedExecutorService((boolean)true));
    }

    protected void initMedaTypeFactories() {
        this.addMediaTypeFactory((MediaTypeFactory)new ApplicationJsonFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new ApplicationXmlFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new TextPlainFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new ApplicationFormFactory());
    }

    public void setRequestCorrelation(boolean hasRequestCorrelation) {
        this._hasRequestCorrelation = hasRequestCorrelation;
    }

    public boolean hasRequestCorrelation() {
        return this._hasRequestCorrelation;
    }

    public void setSessionCorrelation(boolean hasSessionCorrelation) {
        this._hasSessionCorrelation = hasSessionCorrelation;
    }

    public boolean hasSessionCorrelation() {
        return this._hasSessionCorrelation;
    }

    @Override
    public RestResponse doRequest(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest) throws HttpResponseException {
        RestRequestHandler theHandler = this._handler;
        if (theHandler == null) {
            throw new IllegalStateException("Unable to process your request with HTTP-Method <" + aHttpMethod + "> for locator <" + aUrl.toLocator() + "> and query fields <" + new VerboseTextBuilderImpl().withElements((Map)aUrl.getQueryFields()).toString() + "> as no <" + RestRequestHandler.class.getSimpleName() + "> has been registered via <doRestRequest(...)>, aborting!");
        }
        return theHandler.onRestRequest((HttpClientRequest)new HttpClientRequestImpl(aHttpMethod, aUrl, aHeaderFields, aRequest, (MediaTypeFactoryLookup)this));
    }

    @Override
    public RestCallerBuilder doRequest(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver) {
        RestCallerBuilderImpl theRestCaller = new RestCallerBuilderImpl(aHttpMethod, aUrl, aHeaderFields, aRequest, aResponseObserver, (MediaTypeFactoryLookup)this);
        ((RequestHeaderFields)theRestCaller.getHeaderFields()).putUserAgent(this._userAgent);
        this._executorService.execute(new RequestDaemon(theRestCaller));
        return theRestCaller;
    }

    @Override
    public RestRequestBuilder buildRequest(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest) {
        return new RestRequestBuilderImpl(aHttpMethod, aUrl, aHeaderFields, aRequest, this);
    }

    public synchronized boolean addMediaTypeFactory(MediaTypeFactory aMediaTypeFactory) {
        if (this._mediaTypeFacotries.containsKey(aMediaTypeFactory.getMediaType())) {
            return false;
        }
        this._mediaTypeFacotries.put(aMediaTypeFactory.getMediaType(), aMediaTypeFactory);
        return true;
    }

    public MediaTypeFactory toMediaTypeFactory(MediaType aMediaType) {
        return this._mediaTypeFacotries.get(aMediaType);
    }

    public MediaType[] getFactoryMediaTypes() {
        return this._mediaTypeFacotries.keySet().toArray(new MediaType[this._mediaTypeFacotries.size()]);
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String aUserAgent) {
        this._userAgent = aUserAgent;
    }

    protected void onRestRequest(RestRequestHandler aHandler) {
        this._handler = aHandler;
    }

    protected void doRequestCorrelation(RequestHeaderFields aRequestHeaderFields) {
        if (this._hasRequestCorrelation) {
            String theRequestId = Correlation.REQUEST.pullId();
            aRequestHeaderFields.putRequestId(theRequestId);
        }
    }

    protected void doSessionCorrelation(RequestHeaderFields aRequestHeaderFields) {
        if (this._hasSessionCorrelation) {
            String theSessionId = Correlation.SESSION.pullId();
            aRequestHeaderFields.putSessionId(theSessionId);
        }
    }

    protected void doRequestCorrelation(ResponseHeaderFields aResponseHeaderFields) {
        String theRequestId;
        if (this._hasRequestCorrelation && (theRequestId = aResponseHeaderFields.getRequestId()) != null) {
            Correlation.REQUEST.setId(theRequestId);
        }
    }

    protected void doSessionCorrelation(ResponseHeaderFields aResponseHeaderFields) {
        String theSessionId;
        if (this._hasSessionCorrelation && (theSessionId = aResponseHeaderFields.getSessionId()) != null) {
            Correlation.SESSION.setId(theSessionId);
        }
    }

    private class RequestDaemon
    implements Runnable {
        private RestCallerBuilder _restCaller;

        public RequestDaemon(RestCallerBuilder aRestCallerBuilder) {
            this._restCaller = aRestCallerBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RestRequestHandler theHandler = AbstractRestClient.this._handler;
            if (theHandler == null) {
                LOGGER.error("Unable to process your request <" + this._restCaller.toString() + "> as no <" + RestRequestHandler.class.getSimpleName() + "> has been registered via <doRestRequest(...)>, aborting!");
                return;
            }
            try {
                RestCallerBuilder restCallerBuilder = this._restCaller;
                synchronized (restCallerBuilder) {
                    while (this._restCaller.getConnectionStatus() == ConnectionStatus.NONE) {
                        try {
                            this._restCaller.wait(DaemonLoopSleepTime.MAX.getMilliseconds());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this._restCaller.getConnectionStatus() != ConnectionStatus.NONE) continue;
                        LOGGER.warn("Your caller's <" + this._restCaller + "> connection status is still <" + this._restCaller.getConnectionStatus() + "> after <" + DaemonLoopSleepTime.MAX.getMilliseconds() + "> ms, execution of your request starts not earlyer than you calling the #open() method.");
                    }
                }
                if (this._restCaller.getConnectionStatus() != ConnectionStatus.OPENED) {
                    return;
                }
                RestResponse theResponse = theHandler.onRestRequest(this._restCaller);
                this._restCaller.onResponse(new RestResponseEventImpl(theResponse, AbstractRestClient.this));
            }
            catch (HttpResponseException e) {
                LOGGER.error(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                throw new HiddenException((Throwable)e);
            }
        }
    }
}

