// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

import org.refcodes.net.LoadBalancingStrategy;
import org.refcodes.net.LoadBalancingStrategyAccessor;
import org.refcodes.net.Url;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;

/**
 * This context describes all information required to register a server
 * ("service") at a service discovery registry.
 */
public interface HttpDiscoveryContext extends LoadBalancingStrategyAccessor, HttpDiscoveryUrlAccessor, TrustStoreDescriptorAccessor {

	/**
	 * The {@link HttpDiscoveryContextBuilder} interface extends the
	 * {@link HttpDiscoveryContext} with builder functionality as of the builder
	 * pattern.
	 */
	public interface HttpDiscoveryContextBuilder extends LoadBalancingStrategyProperty, LoadBalancingStrategyBuilder<HttpDiscoveryContextBuilder>, HttpDiscoveryUrlProperty, HttpDiscoveryUrlBuilder<HttpDiscoveryContextBuilder>, TrustStoreDescriptorProperty, TrustStoreDescriptorBuilder<HttpDiscoveryContextBuilder> {

		/**
		 * {@inheritDoc}
		 */
		@Override
		default HttpDiscoveryContextBuilder withLoadBalancingStrategy( LoadBalancingStrategy aStrategy ) {
			setLoadBalancingStrategy( aStrategy );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default HttpDiscoveryContextBuilder withHttpDiscoveryUrl( Url aUrl ) {
			setHttpDiscoveryUrl( aUrl );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default HttpDiscoveryContextBuilder withTrustStoreDescriptor( TrustStoreDescriptor aStoreDescriptor ) {
			setTrustStoreDescriptor( aStoreDescriptor );
			return this;
		}
	}
}