// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;

import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerResponse;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.RequestHeaderFieldsImpl;
import org.refcodes.net.Url;

/**
 * Implementation if the {@link LoopbackRestServer} for easy testing of your
 * requests being received by a {@link RestServer} ({@link HttpRestServer}) and
 * the according response <code>lambda</code> expressions.
 */
public class LoopbackRestServerImpl extends AbstractRestServer implements LoopbackRestServer {

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void onHttpRequest( InetSocketAddress aLocalAddress, InetSocketAddress aClientAddress, HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aRequestHeaderFields, InputStream aHttpInputStream, HttpServerResponse aHttpServerResponse ) throws HttpStatusException {
		super.onHttpRequest( aLocalAddress, aClientAddress, aHttpMethod, aUrl, aRequestHeaderFields == null ? new RequestHeaderFieldsImpl() : aRequestHeaderFields, aHttpInputStream, aHttpServerResponse );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void onHttpRequest( InetSocketAddress aLocalAddress, InetSocketAddress aClientAddress, HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aRequestHeaderFields, String aHttpBody, HttpServerResponse aHttpServerResponse ) throws HttpStatusException {
		super.onHttpRequest( aLocalAddress, aClientAddress, aHttpMethod, aUrl, aRequestHeaderFields == null ? new RequestHeaderFieldsImpl() : aRequestHeaderFields, new ByteArrayInputStream( aHttpBody.getBytes( StandardCharsets.UTF_8 ) ), aHttpServerResponse );
	}
}