// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.rest;

import org.refcodes.logger.RuntimeLoggerFactory;

/**
 * The singleton of the {@link LoopbackRestServerImpl} for easy
 * {@link RestServer} access.
 */
public class LoopbackRestServerSingleton extends LoopbackRestServerImpl {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private static LoopbackRestServerSingleton _loopbackRestServerSingleton;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new loopback rest server singleton.
	 */
	protected LoopbackRestServerSingleton() {}

	/**
	 * Returns the singleton's instance as fabricated by this
	 * {@link LoopbackRestServerSingleton}.
	 *
	 * @return The {@link RuntimeLoggerFactory} singleton's instance.
	 */
	public static LoopbackRestServer getInstance() {
		if ( _loopbackRestServerSingleton == null ) {
			synchronized ( LoopbackRestServerSingleton.class ) {
				_loopbackRestServerSingleton = new LoopbackRestServerSingleton();
			}
		}
		return _loopbackRestServerSingleton;
	}
}
