// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

import org.refcodes.net.Url;

/**
 * Provides an accessor for a ping {@link Url} property.
 */
public interface PingUrlAccessor {

	/**
	 * Retrieves the ping {@link Url} from the ping {@link Url} property.
	 * 
	 * @return The ping {@link Url} stored by the ping {@link Url} property.
	 */
	Url getPingUrl();

	/**
	 * Provides a mutator for a ping {@link Url} property.
	 */
	public interface PingUrlMutator {

		/**
		 * Sets the ping {@link Url} for the ping {@link Url} property.
		 * 
		 * @param aPingUrl The ping {@link Url} to be stored by the ping
		 *        {@link Url} property.
		 */
		void setPingUrl( Url aPingUrl );
	}

	/**
	 * Provides a mutator for an ping {@link Url} property.
	 * 
	 * @param <B> The builder which implements the {@link PingUrlBuilder}.
	 */
	public interface PingUrlBuilder<B extends PingUrlBuilder<?>> {

		/**
		 * Sets the ping {@link Url} to use and returns this builder as of the
		 * builder pattern.
		 * 
		 * @param aPingUrl The ping {@link Url} to be stored by the ping
		 *        {@link Url} property.
		 * 
		 * @return This {@link PingUrlBuilder} instance to continue
		 *         configuration.
		 */
		public B withPingUrl( Url aPingUrl );
	}

	/**
	 * Provides a ping {@link Url} property.
	 */
	public interface PingUrlProperty extends PingUrlAccessor, PingUrlMutator {}
}
