// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.runtime;

import org.refcodes.mixin.CorrelationIdAccessor.CorrelationIdProperty;

/**
 * The {@link ProcessCorrelation} assigns a correlation ID to the invoking
 * process, this ID is used in log files and is part of the process's request or
 * response pay-load in order to track process execution throughout a JVM.
 *
 */
public interface ProcessCorrelation extends CorrelationIdProperty {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Assigns the given correlation ID to the current {@link Thread}.
	 * 
	 * @param aCorrelationId The correlation ID to be assigned to the current
	 *        {@link Thread}.
	 */
	@Override
	void setCorrelationId( String aCorrelationId );

	/**
	 * Retrieves the correlation ID assigned to the current {@link Thread}.
	 * 
	 * @return The correlation ID of the current {@link Thread}. In case the
	 *         current thread does not yet have a correlation ID, then a new
	 *         correlation ID is generated.
	 */
	@Override
	String getCorrelationId();
}
