/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.runtime.Terminal;

public class TerminalTest {
    private static String MODE_CON_OUTPUT = "Status von Ger\u00e4t CON:\r\n---------------------\r\n    Zeilen:          9001\r\n    Spalten:         120\r\n    Wiederholrate:   31\r\n    Verz\u00f6gerungszeit:1\r\n    Codepage:        850";

    @Test
    public void testAnsiconWidth() {
        String theAnsiconValue = "91x19999 (91x51)";
        int theWidth = Terminal.toAnsiconWidth((String)theAnsiconValue);
        Assertions.assertEquals((int)91, (int)theWidth);
    }

    @Test
    public void testAnsiconHeight() {
        String theAnsiconValue = "91x19999 (91x51)";
        int theHeight = Terminal.toAnsiconHeight((String)theAnsiconValue);
        Assertions.assertEquals((int)51, (int)theHeight);
    }

    @Test
    public void testModeConWidth() {
        int theWidth = Terminal.toModeConWidth((String)MODE_CON_OUTPUT);
        Assertions.assertEquals((int)120, (int)theWidth);
    }

    @Test
    public void testModeConHeight() {
        int theWidth = Terminal.toModeConHeight((String)MODE_CON_OUTPUT);
        Assertions.assertEquals((int)9001, (int)theWidth);
    }

    @Disabled(value="For debugging purposes only")
    @Test
    public void testConsoleWidth() {
        System.out.println("Width = " + Terminal.getTerminalWidth());
    }
}

