/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.mixin.Dumpable;
import org.refcodes.runtime.DumpBuilder;

public class DumpBuilderImpl
implements DumpBuilder {
    private Object _dumpable = null;

    public Object getObject() {
        return this._dumpable;
    }

    public void setObject(Object aObject) {
        this._dumpable = aObject;
    }

    public DumpBuilder withObject(Object aObject) {
        this.setObject(aObject);
        return this;
    }

    @Override
    public Map<String, String> toDump(Object aObj) {
        return DumpBuilderImpl.toDump(aObj, new HashMap<String, String>());
    }

    protected static Map<String, String> toDump(Object aObj, Map<String, String> aDump) {
        String eStringValue;
        String eKeyString;
        Object eValue;
        Map eMap;
        Class<?> eClass = aObj.getClass();
        if (aObj instanceof Map) {
            eMap = (Map)aObj;
            for (Object eKey : eMap.keySet()) {
                eValue = eMap.get(eKey);
                try {
                    aDump.put(eKey != null ? eKey.toString() : null, eValue != null ? eValue.toString() : null);
                }
                catch (NullPointerException e) {
                    eKeyString = eKey != null ? eKey.toString() : "null";
                    eStringValue = eValue != null ? eValue.toString() : "null";
                    aDump.put(eKeyString, eStringValue);
                }
            }
        }
        do {
            Field[] eFields = eClass.getDeclaredFields();
            for (Field eField : eFields) {
                String eFieldName = eField.getName();
                try {
                    eField.setAccessible(true);
                    eValue = eField.get(aObj);
                    if (eValue instanceof Dumpable) {
                        Map eDump = ((Dumpable)eValue).toDump();
                        for (String eKey : eDump.keySet()) {
                            aDump.put(eFieldName + "." + eKey, (String)eDump.get(eKey));
                        }
                        continue;
                    }
                    if (eValue instanceof Map) {
                        eMap = (Map)eValue;
                        for (String eKey : eMap.keySet()) {
                            eValue = eMap.get(eKey);
                            try {
                                eKeyString = eKey != null ? eKey.toString() : null;
                                eStringValue = eValue != null ? eValue.toString() : null;
                                aDump.put(eFieldName + "." + eKeyString, eStringValue);
                            }
                            catch (NullPointerException e) {
                                eKeyString = eKey != null ? eKey.toString() : "null";
                                eStringValue = eValue != null ? eValue.toString() : "null";
                                aDump.put(eFieldName + "." + eKeyString, eStringValue);
                            }
                        }
                        continue;
                    }
                    eStringValue = eValue != null ? eValue.toString() : null;
                    aDump.put(eFieldName, eStringValue);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    aDump.put(eFieldName, "(unaccessible field)");
                }
            }
        } while ((eClass = eClass.getSuperclass()) != null);
        return aDump;
    }
}

