/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.time;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.time.TimeUnit;

public class TimeUnitTest {
    private static long ONE_YEAR_IN_SECONDS = 31536000L;
    private static long FOUR_DAYS_IN_MINUTES = 5760L;

    @Test
    public void testTimeConversion() {
        float theSeconds = TimeUnit.toTimeUnit((TimeUnit)TimeUnit.YEAR, (long)1L, (TimeUnit)TimeUnit.SECOND);
        Assertions.assertEquals((float)ONE_YEAR_IN_SECONDS, (float)theSeconds);
        float theYear = TimeUnit.toTimeUnit((TimeUnit)TimeUnit.SECOND, (long)ONE_YEAR_IN_SECONDS, (TimeUnit)TimeUnit.YEAR);
        Assertions.assertEquals((float)1.0f, (float)theYear);
        float theMinutes = TimeUnit.toTimeUnit((TimeUnit)TimeUnit.DAY, (long)4L, (TimeUnit)TimeUnit.MINUTE);
        Assertions.assertEquals((float)FOUR_DAYS_IN_MINUTES, (float)theMinutes);
        float theDays = TimeUnit.toTimeUnit((TimeUnit)TimeUnit.MINUTE, (long)FOUR_DAYS_IN_MINUTES, (TimeUnit)TimeUnit.DAY);
        Assertions.assertEquals((float)4.0f, (float)theDays);
    }
}

