/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.application;

import java.io.File;
import java.io.FileWriter;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.restcomm.connect.application.RvdProjectsMigrationException;
import org.restcomm.connect.application.RvdProjectsMigrationHelper;

public class RvdProjectsMigrator {
    private static final Logger logger = Logger.getLogger(RvdProjectsMigrator.class);
    private static final String separator = "--------------------------------------";
    private RvdProjectsMigrationHelper migrationHelper;
    private List<String> projectNames;
    private boolean migrationSucceeded;
    private Integer errorCode;
    private String logPath;
    private int projectsProcessed;
    private int projectsSuccess;
    private int projectsError;
    private int updatedDids;
    private int updatedClients;

    public RvdProjectsMigrator(ServletContext servletContext, Configuration configuration) throws Exception {
        this.migrationHelper = new RvdProjectsMigrationHelper(servletContext, configuration);
        this.migrationSucceeded = true;
        this.logPath = servletContext.getRealPath("/") + "../../../";
        this.errorCode = 0;
        this.projectsProcessed = 0;
        this.projectsSuccess = 0;
        this.projectsError = 0;
        this.updatedDids = 0;
        this.updatedClients = 0;
    }

    public void executeMigration() throws Exception {
        String beginning = this.getTimeStamp();
        if (!this.migrationHelper.isMigrationEnabled() || this.migrationHelper.isMigrationExecuted()) {
            this.storeNewMessage("Workspace migration skipped in " + beginning, true, true, true, false);
            this.storeNewMessage(separator, false, true, false, false);
            return;
        }
        this.storeNewMessage("Starting workspace migration at " + beginning, true, true, true, false);
        this.storeNewMessage(separator, false, true, false, false);
        try {
            if (!this.migrationHelper.isEmbeddedMigration()) {
                this.backupWorkspace();
            }
            this.loadProjectsList();
        }
        catch (RvdProjectsMigrationException e) {
            this.migrationSucceeded = false;
            this.errorCode = e.getErrorCode();
            this.storeNewMessage(e.getMessage(), true, true, false, true);
            try {
                this.storeMigrationStatus();
            }
            catch (Exception x) {
                this.storeNewMessage("[ERROR-CODE:2] Error while storing workspace status" + x.getMessage(), true, true, false, true);
            }
            throw e;
        }
        for (String projectName : this.projectNames) {
            try {
                this.migrationHelper.loadProjectState(projectName);
                String applicationSid = this.searchApplicationSid(projectName);
                applicationSid = this.synchronizeApplicationEntity(applicationSid, projectName);
                this.migrateNamingConvention(projectName, applicationSid);
                this.updateIncomingPhoneNumbers(applicationSid, projectName);
                this.updateClients(applicationSid, projectName);
                ++this.projectsSuccess;
            }
            catch (RvdProjectsMigrationException e) {
                this.migrationSucceeded = false;
                if (this.errorCode == 0) {
                    this.errorCode = e.getErrorCode();
                }
                ++this.projectsError;
                this.storeNewMessage("Error while migrating project '" + projectName + "' " + e.getMessage(), false, true, false, true);
            }
            ++this.projectsProcessed;
            this.storeNewMessage(separator, false, true, false, false);
        }
        try {
            this.storeMigrationStatus();
        }
        catch (Exception e) {
            this.storeNewMessage("[ERROR-CODE:2] Error while storing workspace status " + e, true, true, false, true);
            throw e;
        }
    }

    private void loadProjectsList() throws Exception {
        this.projectNames = this.migrationHelper.listProjects();
    }

    private String searchApplicationSid(String projectName) throws RvdProjectsMigrationException {
        return this.migrationHelper.searchApplicationSid(projectName);
    }

    private String synchronizeApplicationEntity(String applicationSid, String projectName) throws RvdProjectsMigrationException, URISyntaxException {
        if (!projectName.equals(applicationSid)) {
            applicationSid = this.migrationHelper.createOrUpdateApplicationEntity(applicationSid, projectName);
            this.storeNewMessage("Project '" + projectName + "' synchronized with Application '" + applicationSid + "'", false, true, false, false);
        } else {
            this.storeNewMessage("Project '" + projectName + "' previously synchronized with Application '" + applicationSid + "'. Skipped", false, true, false, false);
        }
        return applicationSid;
    }

    private void migrateNamingConvention(String projectName, String applicationSid) throws RvdProjectsMigrationException, URISyntaxException {
        if (!projectName.equals(applicationSid)) {
            this.migrationHelper.renameProjectUsingNewConvention(projectName, applicationSid);
            this.storeNewMessage("Project '" + projectName + "' renamed to '" + applicationSid + "'", false, true, false, false);
        } else {
            this.storeNewMessage("Project " + projectName + " already using new naming convention. Skipped", false, true, false, false);
        }
    }

    private void updateIncomingPhoneNumbers(String applicationSid, String projectName) throws RvdProjectsMigrationException, URISyntaxException {
        int amountUpdated = this.migrationHelper.updateIncomingPhoneNumbers(applicationSid, projectName);
        if (amountUpdated > 0) {
            this.storeNewMessage("Updated " + amountUpdated + " IncomingPhoneNumbers with Application '" + applicationSid + "'", false, true, false, false);
            this.updatedDids += amountUpdated;
        } else {
            this.storeNewMessage("No IncomingPhoneNumbers found to update with Application '" + applicationSid + "'. Skipped", false, true, false, false);
        }
    }

    private void updateClients(String applicationSid, String projectName) throws RvdProjectsMigrationException, URISyntaxException {
        int amountUpdated = this.migrationHelper.updateClients(applicationSid, projectName);
        if (amountUpdated > 0) {
            this.storeNewMessage("Updated " + amountUpdated + " Clients with Application '" + applicationSid + "'", false, true, false, false);
            this.updatedClients += amountUpdated;
        } else {
            this.storeNewMessage("No Clients found to update with Application '" + applicationSid + "'. Skipped", false, true, false, false);
        }
    }

    private void storeMigrationStatus() throws RvdProjectsMigrationException, URISyntaxException {
        this.migrationHelper.storeWorkspaceStatus(this.migrationSucceeded);
        String end = this.getTimeStamp();
        if (!this.migrationSucceeded) {
            String message = "Workspace migration finished with errors at " + end;
            message = message + ". Status: " + this.projectsProcessed + " Projects processed (";
            message = message + this.projectsSuccess + " with success and " + this.projectsError + " with error), ";
            message = message + this.updatedDids + " IncomingPhoneNumbers and " + this.updatedClients + " Clients updated";
            this.storeNewMessage(message, true, true, true, true);
            this.storeNewMessage(separator, false, true, false, false);
            this.sendEmailNotification(message);
        } else {
            String message = "Workspace migration finished with success at " + end;
            message = message + ". Status: " + this.projectsProcessed + " Projects processed (";
            message = message + this.projectsSuccess + " with success and " + this.projectsError + " with error), ";
            message = message + this.updatedDids + " IncomingPhoneNumbers and " + this.updatedClients + " Clients updated";
            this.storeNewMessage(message, true, true, true, false);
            this.storeNewMessage(separator, false, true, false, false);
            this.sendEmailNotification(message);
        }
    }

    private void storeNewMessage(String message, boolean asServerLog, boolean asMigrationLog, boolean asNotification, boolean error) throws RvdProjectsMigrationException, URISyntaxException {
        if (asServerLog) {
            if (error) {
                logger.error((Object)message);
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)message);
            }
        }
        if (asMigrationLog) {
            if (!this.migrationHelper.isEmbeddedMigration()) {
                this.storeLogMessage(message);
            } else if (!asServerLog) {
                if (error) {
                    logger.error((Object)message);
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)message);
                }
            }
        }
        if (asNotification) {
            this.storeNewNotification(message);
        }
    }

    private void storeLogMessage(String message) throws RvdProjectsMigrationException, URISyntaxException {
        try {
            String pathName = this.logPath + "workspace-migration.log";
            File file = new File(pathName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file, true);
            fw.write(message + "\n");
            fw.close();
        }
        catch (Exception e) {
            this.storeNewMessage("[ERROR-CODE:3] Error while writing to file RESTCOMM_HOME/workspace-migration.log", true, false, false, true);
        }
    }

    private String getTimeStamp() {
        LocalDateTime date = LocalDateTime.now();
        DateTimeZone tz = DateTimeZone.getDefault();
        return new Timestamp(date.toDateTime(tz).toDateTime(DateTimeZone.UTC).getMillis()).toString();
    }

    private void storeNewNotification(String message) throws URISyntaxException {
        this.migrationHelper.addNotification(message, this.migrationSucceeded, new Integer(this.errorCode));
    }

    private void sendEmailNotification(String message) throws RvdProjectsMigrationException, URISyntaxException {
        try {
            this.migrationHelper.sendEmailNotification(message, this.migrationSucceeded);
        }
        catch (RvdProjectsMigrationException e) {
            this.storeNewMessage("[ERROR-CODE:4] Workspace migration email notification skipped due to invalid configuration", true, true, false, true);
            this.storeNewMessage(separator, false, true, false, false);
        }
    }

    private void backupWorkspace() throws RvdProjectsMigrationException {
        this.migrationHelper.backupWorkspace();
    }
}

