/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.email.api;

import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;

@Immutable
public final class Mail {
    private final String from;
    private final String to;
    private final String cc;
    private final String bcc;
    private final String subject;
    private final String body;
    private final DateTime dateSent;
    private final String accountSid;

    public Mail(String from, String to, String subject, String body) {
        this.from = from;
        this.to = to;
        this.cc = "";
        this.bcc = "";
        this.subject = subject;
        this.body = body;
        this.dateSent = DateTime.now();
        this.accountSid = "";
    }

    public Mail(String from, String to, String subject, String body, String cc, String bcc) {
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.body = body;
        this.dateSent = DateTime.now();
        this.accountSid = "";
    }

    public Mail(String from, String to, String subject, String body, String cc, String bcc, DateTime dateSent, String accountSid) {
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.body = body;
        this.dateSent = dateSent;
        this.accountSid = accountSid;
    }

    public String from() {
        return this.from;
    }

    public String to() {
        return this.to;
    }

    public String cc() {
        return this.cc;
    }

    public String bcc() {
        return this.bcc;
    }

    public String subject() {
        return this.subject;
    }

    public String body() {
        return this.body;
    }

    public String accountSid() {
        return this.accountSid;
    }

    public DateTime dateSent() {
        return this.dateSent;
    }
}

