/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.dao.entities.ApplicationList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.ApplicationConverter;
import org.restcomm.connect.http.converter.ApplicationListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;

@NotThreadSafe
public class ApplicationsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected ApplicationsDao dao;
    protected Gson gson;
    protected XStream xstream;
    protected AccountsDao accountsDao;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.dao = storage.getApplicationsDao();
        this.accountsDao = storage.getAccountsDao();
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        ApplicationConverter converter = new ApplicationConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Application.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new ApplicationListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    private Application createFrom(Sid accountSid, MultivaluedMap<String, String> data) {
        Application.Builder builder = Application.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.APPLICATION);
        builder.setSid(sid);
        builder.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        builder.setAccountSid(accountSid);
        builder.setApiVersion(this.getApiVersion(data));
        builder.setHasVoiceCallerIdLookup(new Boolean((String)data.getFirst((Object)"VoiceCallerIdLookup")).booleanValue());
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(this.getApiVersion(data)).append("/Accounts/").append(accountSid.toString()).append("/Applications/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        builder.setRcmlUrl(this.getUrl("RcmlUrl", data));
        if (data.containsKey((Object)"Kind")) {
            builder.setKind(Application.Kind.getValueOf((String)((String)data.getFirst((Object)"Kind"))));
        }
        return builder.build();
    }

    protected Response getApplication(String accountSid, String sid, MediaType responseType) {
        Account account = this.accountsDao.getAccount(accountSid);
        this.secure(account, "RestComm:Read:Applications");
        Application application = null;
        if (Sid.pattern.matcher(sid).matches()) {
            application = this.dao.getApplication(new Sid(sid));
        }
        if (application == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, application.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_APP);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)application);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)application), (String)"application/json").build();
        }
        return null;
    }

    protected Response getApplications(String accountSid, MediaType responseType) {
        Account account = this.accountsDao.getAccount(accountSid);
        this.secure(account, "RestComm:Read:Applications", SecuredEndpoint.SecuredType.SECURED_APP);
        List applications = this.dao.getApplications(account.getSid());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new ApplicationList(applications));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)applications), (String)"application/json").build();
        }
        return null;
    }

    public Response putApplication(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        Account account = this.accountsDao.getAccount(accountSid);
        this.secure(account, "RestComm:Create:Applications", SecuredEndpoint.SecuredType.SECURED_APP);
        try {
            this.validate(data);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        Application application = this.createFrom(new Sid(accountSid), data);
        this.dao.addApplication(application);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)application);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)application), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) throws RuntimeException {
        if (!data.containsKey((Object)"FriendlyName")) {
            throw new NullPointerException("Friendly name can not be null.");
        }
    }

    protected Response updateApplication(String accountSid, String sid, MultivaluedMap<String, String> data, MediaType responseType) {
        Account account = this.accountsDao.getAccount(accountSid);
        this.secure(account, "RestComm:Modify:Applications");
        Application application = this.dao.getApplication(new Sid(sid));
        if (application == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, application.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_APP);
        Application applicationUpdate = this.update(application, data);
        this.dao.updateApplication(applicationUpdate);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)applicationUpdate);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)applicationUpdate), (String)"application/json").build();
        }
        return null;
    }

    private Application update(Application application, MultivaluedMap<String, String> data) {
        Application result = application;
        if (data.containsKey((Object)"FriendlyName")) {
            result = result.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        }
        if (data.containsKey((Object)"VoiceCallerIdLookup")) {
            result = result.setVoiceCallerIdLookup(new Boolean((String)data.getFirst((Object)"VoiceCallerIdLookup")).booleanValue());
        }
        if (data.containsKey((Object)"RcmlUrl")) {
            result = result.setRcmlUrl(this.getUrl("RcmlUrl", data));
        }
        if (data.containsKey((Object)"Kind")) {
            result = result.setKind(Application.Kind.getValueOf((String)((String)data.getFirst((Object)"Kind"))));
        }
        return result;
    }
}

