/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.client.rcmlserver;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.common.http.CustomHttpClientBuilder;
import org.restcomm.connect.commons.configuration.sets.MainConfigurationSet;
import org.restcomm.connect.commons.configuration.sets.RcmlserverConfigurationSet;
import org.restcomm.connect.commons.util.SecurityUtils;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.http.exceptions.RcmlserverNotifyError;

public class RcmlserverApi {
    static final Logger logger = Logger.getLogger((String)RcmlserverApi.class.getName());
    URI apiUrl;
    MainConfigurationSet mainConfig;
    RcmlserverConfigurationSet rcmlserverConfig;

    public RcmlserverApi(MainConfigurationSet mainConfig, RcmlserverConfigurationSet rcmlserverConfig) {
        try {
            this.apiUrl = UriUtils.resolve((URI)new URI(rcmlserverConfig.getBaseUrl()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.rcmlserverConfig = rcmlserverConfig;
        this.mainConfig = mainConfig;
    }

    public void transmitNotifications(List<JsonObject> notifications, String notifierUsername, String notifierPassword) throws RcmlserverNotifyError {
        String notificationUrl = this.apiUrl + "/notifications";
        HttpPost request = new HttpPost(notificationUrl);
        String authHeader = SecurityUtils.buildBasicAuthHeader((String)notifierUsername, (String)notifierPassword);
        request.setHeader("Authorization", authHeader);
        Gson gson = new Gson();
        String json = gson.toJson(notifications);
        request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        Integer totalTimeout = this.rcmlserverConfig.getTimeout() + notifications.size() * this.rcmlserverConfig.getTimeoutPerNotification();
        HttpClient httpClient = CustomHttpClientBuilder.build((MainConfigurationSet)this.mainConfig, (int)totalTimeout);
        try {
            logger.info((Object)("Will transmit a set of " + notifications.size() + " notifications and wait at most for " + totalTimeout));
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RcmlserverNotifyError();
            }
            logger.info((Object)("Transmitted a set of " + notifications.size() + " notification(s) to rcmlserver"));
        }
        catch (IOException e) {
            throw new RcmlserverNotifyError("Transmission of " + notifications.size() + " notifications failed.", e);
        }
    }

    public JsonObject buildAccountClosingNotification(Account closedAccount) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", NotificationType.accountClosed.toString());
        jsonObject.addProperty("accountSid", closedAccount.getSid().toString());
        return jsonObject;
    }

    static enum NotificationType {
        accountClosed;

    }
}

