/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class AccountConverter
extends AbstractConverter
implements JsonSerializer<Account> {
    private final String apiVersion;

    public AccountConverter(Configuration configuration) {
        super(configuration);
        this.apiVersion = configuration.getString("api-version");
    }

    @Override
    public boolean canConvert(Class klass) {
        return Account.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Account account = (Account)object;
        writer.startNode("Account");
        this.writeSid(account.getSid(), writer);
        this.writeFriendlyName(account.getFriendlyName(), writer);
        this.writeEmailAddress(account, writer);
        this.writeStatus(account.getStatus().toString(), writer);
        this.writeRoleInfo(account.getRole(), writer);
        this.writeType(account.getType().toString(), writer);
        this.writeDateCreated(account.getDateCreated(), writer);
        this.writeDateUpdated(account.getDateUpdated(), writer);
        this.writeAuthToken(account, writer);
        this.writeUri(account.getUri(), writer);
        this.writeSubResourceUris(account, writer);
        writer.endNode();
    }

    public JsonElement serialize(Account account, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(account.getSid(), object);
        this.writeFriendlyName(account.getFriendlyName(), object);
        this.writeEmailAddress(account, object);
        this.writeType(account.getType().toString(), object);
        this.writeStatus(account.getStatus().toString(), object);
        this.writeRoleInfo(account.getRole(), object);
        this.writeDateCreated(account.getDateCreated(), object);
        this.writeDateUpdated(account.getDateUpdated(), object);
        this.writeAuthToken(account, object);
        this.writeUri(account, object);
        this.writeSubResourceUris(account, object);
        return object;
    }

    protected void writeUri(Account account, JsonObject object) {
        object.addProperty("uri", this.prefix(account, MediaType.APPLICATION_JSON_TYPE));
    }

    private String prefix(Account account) {
        return this.prefix(account, MediaType.APPLICATION_XML_TYPE);
    }

    private String prefix(Account account, MediaType responseType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(this.apiVersion).append("/Accounts");
        if (responseType == MediaType.APPLICATION_JSON_TYPE) {
            buffer.append(".json");
        }
        buffer.append("/" + account.getSid().toString());
        return buffer.toString();
    }

    private void writeAuthToken(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("AuthToken");
        writer.setValue(account.getAuthToken());
        writer.endNode();
    }

    private void writeAuthToken(Account account, JsonObject object) {
        object.addProperty("auth_token", account.getAuthToken());
    }

    private void writeAvailablePhoneNumbers(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("AvailablePhoneNumbers");
        writer.setValue(this.prefix(account) + "/AvailablePhoneNumbers");
        writer.endNode();
    }

    private void writeAvailablePhoneNumbers(Account account, JsonObject object) {
        object.addProperty("available_phone_numbers", this.prefix(account) + "/AvailablePhoneNumbers.json");
    }

    private void writeCalls(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("Calls");
        writer.setValue(this.prefix(account) + "/Calls");
        writer.endNode();
    }

    private void writeCalls(Account account, JsonObject object) {
        object.addProperty("calls", this.prefix(account) + "/Calls.json");
    }

    private void writeConferences(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("Conferences");
        writer.setValue(this.prefix(account) + "/Conferences");
        writer.endNode();
    }

    private void writeConferences(Account account, JsonObject object) {
        object.addProperty("conferences", this.prefix(account) + "/Conferences.json");
    }

    private void writeIncomingPhoneNumbers(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("IncomingPhoneNumbers");
        writer.setValue(this.prefix(account) + "/IncomingPhoneNumbers");
        writer.endNode();
    }

    private void writeIncomingPhoneNumbers(Account account, JsonObject object) {
        object.addProperty("incoming_phone_numbers", this.prefix(account) + "/IncomingPhoneNumbers.json");
    }

    private void writeNotifications(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("Notifications");
        writer.setValue(this.prefix(account) + "/Notifications");
        writer.endNode();
    }

    private void writeNotifications(Account account, JsonObject object) {
        object.addProperty("notifications", this.prefix(account) + "/Notifications.json");
    }

    private void writeOutgoingCallerIds(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("OutgoingCallerIds");
        writer.setValue(this.prefix(account) + "/OutgoingCallerIds");
        writer.endNode();
    }

    private void writeOutgoingCallerIds(Account account, JsonObject object) {
        object.addProperty("outgoing_caller_ids", this.prefix(account) + "/OutgoingCallerIds.json");
    }

    private void writeRecordings(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("Recordings");
        writer.setValue(this.prefix(account) + "/Recordings");
        writer.endNode();
    }

    private void writeRecordings(Account account, JsonObject object) {
        object.addProperty("recordings", this.prefix(account) + "/Recordings.json");
    }

    private void writeSandBox(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("Sandbox");
        writer.setValue(this.prefix(account) + "/Sandbox");
        writer.endNode();
    }

    private void writeSandBox(Account account, JsonObject object) {
        object.addProperty("sandbox", this.prefix(account) + "/Sandbox.json");
    }

    private void writeSmsMessages(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("SMSMessages");
        writer.setValue(this.prefix(account) + "/SMS/Messages");
        writer.endNode();
    }

    private void writeSmsMessages(Account account, JsonObject object) {
        object.addProperty("sms_messages", this.prefix(account) + "/SMS/Messages.json");
    }

    private void writeSubResourceUris(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("SubresourceUris");
        this.writeAvailablePhoneNumbers(account, writer);
        this.writeCalls(account, writer);
        this.writeConferences(account, writer);
        this.writeIncomingPhoneNumbers(account, writer);
        this.writeNotifications(account, writer);
        this.writeOutgoingCallerIds(account, writer);
        this.writeRecordings(account, writer);
        this.writeSandBox(account, writer);
        this.writeSmsMessages(account, writer);
        this.writeTranscriptions(account, writer);
        writer.endNode();
    }

    private void writeSubResourceUris(Account account, JsonObject object) {
        JsonObject other = new JsonObject();
        this.writeAvailablePhoneNumbers(account, other);
        this.writeCalls(account, other);
        this.writeConferences(account, other);
        this.writeIncomingPhoneNumbers(account, other);
        this.writeNotifications(account, other);
        this.writeOutgoingCallerIds(account, other);
        this.writeRecordings(account, other);
        this.writeSandBox(account, other);
        this.writeSmsMessages(account, other);
        this.writeTranscriptions(account, other);
        object.add("subresource_uris", (JsonElement)other);
    }

    private void writeTranscriptions(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("Transcriptions");
        writer.setValue(this.prefix(account) + "/Transcriptions");
        writer.endNode();
    }

    private void writeTranscriptions(Account account, JsonObject object) {
        object.addProperty("transcriptions", this.prefix(account) + "/Transcriptions.json");
    }

    private void writeEmailAddress(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("EmailAddress");
        writer.setValue(account.getEmailAddress());
        writer.endNode();
        writer.close();
    }

    private void writeEmailAddress(Account account, JsonObject object) {
        object.addProperty("email_address", account.getEmailAddress());
    }

    private void writeRoleInfo(String role, HierarchicalStreamWriter writer) {
        writer.startNode("Role");
        writer.setValue(role);
        writer.endNode();
        writer.close();
    }

    private void writeRoleInfo(String role, JsonObject object) {
        object.addProperty("role", role);
    }
}

