/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.TranscriptionsDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.dao.entities.Transcription;
import org.restcomm.connect.dao.entities.TranscriptionFilter;
import org.restcomm.connect.dao.entities.TranscriptionList;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.http.converter.TranscriptionConverter;
import org.restcomm.connect.http.converter.TranscriptionListConverter;

@NotThreadSafe
public abstract class TranscriptionsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected TranscriptionsDao dao;
    protected Gson gson;
    protected XStream xstream;
    protected TranscriptionListConverter listConverter;
    protected String instanceId;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        this.dao = storage.getTranscriptionsDao();
        TranscriptionConverter converter = new TranscriptionConverter(this.configuration);
        this.listConverter = new TranscriptionListConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Transcription.class, (Object)converter);
        builder.registerTypeAdapter(TranscriptionList.class, (Object)this.listConverter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new TranscriptionListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
    }

    protected Response getTranscription(String accountSid, String sid, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Read:Transcriptions");
        Transcription transcription = this.dao.getTranscription(new Sid(sid));
        if (transcription == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(operatedAccount, transcription.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)transcription), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)transcription);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getTranscriptions(String accountSid, UriInfo info, MediaType responseType) {
        TranscriptionFilter filter;
        TranscriptionFilter filterForTotal;
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Transcriptions");
        boolean localInstanceOnly = true;
        try {
            String localOnly = (String)info.getQueryParameters().getFirst((Object)"localOnly");
            if (localOnly != null && localOnly.equalsIgnoreCase("false")) {
                localInstanceOnly = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean querySubAccounts = false;
        String querySubAccountsParam = (String)info.getQueryParameters().getFirst((Object)"SubAccounts");
        if (querySubAccountsParam != null && querySubAccountsParam.equalsIgnoreCase("true")) {
            querySubAccounts = true;
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String startTime = (String)info.getQueryParameters().getFirst((Object)"StartTime");
        String endTime = (String)info.getQueryParameters().getFirst((Object)"EndTime");
        String transcriptionText = (String)info.getQueryParameters().getFirst((Object)"TranscriptionText");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page.equals("0") ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        ArrayList<String> ownerAccounts = null;
        if (querySubAccounts) {
            ownerAccounts = new ArrayList<String>();
            ownerAccounts.add(accountSid);
            ownerAccounts.addAll(this.accountsDao.getSubAccountSidsRecursive(new Sid(accountSid)));
        }
        try {
            filterForTotal = localInstanceOnly ? new TranscriptionFilter(accountSid, ownerAccounts, startTime, endTime, transcriptionText, null, null) : new TranscriptionFilter(accountSid, ownerAccounts, startTime, endTime, transcriptionText, null, null, this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = this.dao.getTotalTranscription(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            filter = localInstanceOnly ? new TranscriptionFilter(accountSid, ownerAccounts, startTime, endTime, transcriptionText, Integer.valueOf(limit), Integer.valueOf(offset)) : new TranscriptionFilter(accountSid, ownerAccounts, startTime, endTime, transcriptionText, Integer.valueOf(limit), Integer.valueOf(offset), this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List cdrs = this.dao.getTranscriptions(filter);
        this.listConverter.setCount(total);
        this.listConverter.setPage(Integer.parseInt(page));
        this.listConverter.setPageSize(Integer.parseInt(pageSize));
        this.listConverter.setPathUri(info.getRequestUri().getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new TranscriptionList(cdrs));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new TranscriptionList(cdrs)), (String)"application/json").build();
        }
        return null;
    }
}

