/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.cors;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.configuration.sets.impl.RcmlserverConfigurationSetImpl;
import org.restcomm.connect.commons.configuration.sources.ApacheConfigurationSource;
import org.restcomm.connect.commons.configuration.sources.ConfigurationSource;

@Provider
public class CorsFilter
implements ContainerResponseFilter {
    private final Logger logger = Logger.getLogger(CorsFilter.class);
    @Context
    private HttpServletRequest servletRequest;
    private ServletContext lazyServletContext;
    String allowedOrigin;

    public ContainerResponse filter(ContainerRequest cres, ContainerResponse response) {
        this.initLazily((ServletRequest)this.servletRequest);
        String requestOrigin = cres.getHeaderValue("Origin");
        if (requestOrigin != null && this.allowedOrigin != null && this.allowedOrigin.startsWith(requestOrigin)) {
            response.getHttpHeaders().add((Object)"Access-Control-Allow-Origin", (Object)requestOrigin);
            response.getHttpHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization");
            response.getHttpHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
            response.getHttpHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD");
            response.getHttpHeaders().add((Object)"Access-Control-Max-Age", (Object)"1209600");
        }
        return response;
    }

    private void initLazily(ServletRequest request) {
        if (this.lazyServletContext == null) {
            ServletContext context = request.getServletContext();
            String rootPath = context.getRealPath("/");
            rootPath = StringUtils.stripEnd((String)rootPath, (String)"/");
            String restcommXmlPath = rootPath + "/WEB-INF/conf/restcomm.xml";
            File restcommXmlFile = new File(restcommXmlPath);
            XMLConfiguration apacheConf = new XMLConfiguration();
            apacheConf.setDelimiterParsingDisabled(true);
            apacheConf.setAttributeSplittingDisabled(true);
            try {
                apacheConf.load(restcommXmlPath);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            ApacheConfigurationSource source = new ApacheConfigurationSource((Configuration)apacheConf);
            RcmlserverConfigurationSetImpl rcmlserverConfig = new RcmlserverConfigurationSetImpl((ConfigurationSource)source);
            String baseUrl = rcmlserverConfig.getBaseUrl();
            if (baseUrl != null && !baseUrl.trim().equals("")) {
                this.allowedOrigin = baseUrl;
            }
            this.lazyServletContext = context;
            this.logger.info((Object)("Initialized (lazily) CORS servlet response filter. allowedOrigin: " + this.allowedOrigin));
        }
    }
}

