/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class ApplicationConverter
extends AbstractConverter
implements JsonSerializer<Application> {
    public ApplicationConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Application.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Application application = (Application)object;
        writer.startNode("Application");
        this.writeSid(application.getSid(), writer);
        this.writeDateCreated(application.getDateCreated(), writer);
        this.writeDateUpdated(application.getDateUpdated(), writer);
        this.writeFriendlyName(application.getFriendlyName(), writer);
        this.writeAccountSid(application.getAccountSid(), writer);
        this.writeApiVersion(application.getApiVersion(), writer);
        this.writeVoiceCallerIdLookup((boolean)application.hasVoiceCallerIdLookup(), writer);
        this.writeUri(application.getUri(), writer);
        this.writeRcmlUrl(application.getRcmlUrl(), writer);
        this.writeKind(application.getKind(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Application application, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(application.getSid(), object);
        this.writeDateCreated(application.getDateCreated(), object);
        this.writeDateUpdated(application.getDateUpdated(), object);
        this.writeFriendlyName(application.getFriendlyName(), object);
        this.writeAccountSid(application.getAccountSid(), object);
        this.writeApiVersion(application.getApiVersion(), object);
        this.writeVoiceCallerIdLookup((boolean)application.hasVoiceCallerIdLookup(), object);
        this.writeUri(application.getUri(), object);
        this.writeRcmlUrl(application.getRcmlUrl(), object);
        this.writeKind(application.getKind(), object);
        return object;
    }

    private void writeRcmlUrl(URI rcmlUrl, HierarchicalStreamWriter writer) {
        if (rcmlUrl != null) {
            writer.startNode("RcmlUrl");
            writer.setValue(rcmlUrl.toString());
            writer.endNode();
        }
    }

    private void writeRcmlUrl(URI rcmlUrl, JsonObject object) {
        if (rcmlUrl != null) {
            object.addProperty("rcml_url", rcmlUrl.toString());
        } else {
            object.add("rcml_url", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeKind(Application.Kind kind, HierarchicalStreamWriter writer) {
        if (kind != null) {
            writer.startNode("Kind");
            writer.setValue(kind.toString());
            writer.endNode();
        }
    }

    private void writeKind(Application.Kind kind, JsonObject object) {
        if (kind != null) {
            object.addProperty("kind", kind.toString());
        } else {
            object.add("kind", (JsonElement)JsonNull.INSTANCE);
        }
    }
}

