/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.amazonS3.RecordingSecurityLevel;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class RecordingConverter
extends AbstractConverter
implements JsonSerializer<Recording> {
    private RecordingSecurityLevel securityLevel = RecordingSecurityLevel.SECURE;

    public RecordingConverter(Configuration configuration) {
        super(configuration);
    }

    public void setSecurityLevel(RecordingSecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    @Override
    public boolean canConvert(Class klass) {
        return Recording.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Recording recording = (Recording)object;
        writer.startNode("Recording");
        this.writeSid(recording.getSid(), writer);
        this.writeDateCreated(recording.getDateCreated(), writer);
        this.writeDateUpdated(recording.getDateUpdated(), writer);
        this.writeAccountSid(recording.getAccountSid(), writer);
        this.writeCallSid(recording.getCallSid(), writer);
        this.writeDuration((double)recording.getDuration(), writer);
        this.writeApiVersion(recording.getApiVersion(), writer);
        this.writeUri(recording.getUri(), writer);
        writer.startNode("FileUri");
        writer.setValue(recording.getFileUri().toString());
        writer.endNode();
        if (this.securityLevel.equals((Object)RecordingSecurityLevel.NONE) && recording.getS3Uri() != null) {
            writer.startNode("S3Uri");
            writer.setValue(recording.getS3Uri().toString());
            writer.endNode();
        }
        writer.endNode();
    }

    public JsonElement serialize(Recording recording, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(recording.getSid(), object);
        this.writeDateCreated(recording.getDateCreated(), object);
        this.writeDateUpdated(recording.getDateUpdated(), object);
        this.writeAccountSid(recording.getAccountSid(), object);
        this.writeCallSid(recording.getCallSid(), object);
        this.writeDuration((double)recording.getDuration(), object);
        this.writeApiVersion(recording.getApiVersion(), object);
        this.writeUri(recording.getUri(), object);
        if (recording.getFileUri() != null) {
            object.addProperty("file_uri", recording.getFileUri().toString());
        }
        if (this.securityLevel.equals((Object)RecordingSecurityLevel.NONE) && recording.getS3Uri() != null) {
            object.addProperty("s3_uri", recording.getS3Uri().toString());
        }
        return object;
    }
}

