/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.tts.acapela;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.restcomm.connect.commons.cache.HashGenerator;
import org.restcomm.connect.commons.util.HttpUtils;
import org.restcomm.connect.tts.api.GetSpeechSynthesizerInfo;
import org.restcomm.connect.tts.api.SpeechSynthesizerException;
import org.restcomm.connect.tts.api.SpeechSynthesizerInfo;
import org.restcomm.connect.tts.api.SpeechSynthesizerRequest;
import org.restcomm.connect.tts.api.SpeechSynthesizerResponse;

public final class AcapelaSpeechSynthesizer
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private static final String client = "0-01";
    private static final String environment = "RESTCOMM_1.6.0";
    private static final String mime = "WAV";
    private static final String version = "2";
    private static final List<NameValuePair> parameters = new ArrayList<NameValuePair>();
    private final URI service;
    private final Map<String, String> men;
    private final Map<String, String> women;

    public AcapelaSpeechSynthesizer(Configuration configuration) {
        String application = configuration.getString("application");
        String login = configuration.getString("login");
        String password = configuration.getString("password");
        parameters.add((NameValuePair)new BasicNameValuePair("cl_app", application));
        parameters.add((NameValuePair)new BasicNameValuePair("cl_login", login));
        parameters.add((NameValuePair)new BasicNameValuePair("cl_pwd", password));
        this.service = URI.create(configuration.getString("service-root"));
        this.men = new HashMap<String, String>();
        this.women = new HashMap<String, String>();
        this.load(configuration);
    }

    private SpeechSynthesizerInfo info() {
        return new SpeechSynthesizerInfo(this.women.keySet());
    }

    private void load(Configuration configuration) throws RuntimeException {
        this.women.put("bf", configuration.getString("speakers.belgium-french.female"));
        this.women.put("bp", configuration.getString("speakers.brazilian-portuguese.female"));
        this.women.put("en-gb", configuration.getString("speakers.british-english.female"));
        this.women.put("cf", configuration.getString("speakers.canadian-french.female"));
        this.women.put("cs", configuration.getString("speakers.czech.female"));
        this.women.put("dan", configuration.getString("speakers.danish.female"));
        this.women.put("en", configuration.getString("speakers.english.female"));
        this.women.put("fi", configuration.getString("speakers.finnish.female"));
        this.women.put("fr", configuration.getString("speakers.french.female"));
        this.women.put("de", configuration.getString("speakers.german.female"));
        this.women.put("el", configuration.getString("speakers.greek.female"));
        this.women.put("it", configuration.getString("speakers.italian.female"));
        this.women.put("nl", configuration.getString("speakers.netherlands-dutch.female"));
        this.women.put("no", configuration.getString("speakers.norwegian.female"));
        this.women.put("pl", configuration.getString("speakers.polish.female"));
        this.women.put("pt", configuration.getString("speakers.portuguese.female"));
        this.women.put("ru", configuration.getString("speakers.russian.female"));
        this.women.put("ar", configuration.getString("speakers.saudi-arabia-arabic.female"));
        this.women.put("ca", configuration.getString("speakers.spain-catalan.female"));
        this.women.put("es", configuration.getString("speakers.spanish.female"));
        this.women.put("sv", configuration.getString("speakers.swedish.female"));
        this.women.put("tr", configuration.getString("speakers.turkish.female"));
        this.women.put("zh-cn", configuration.getString("speakers.mandarin-chinese.female"));
        this.women.put("ja", configuration.getString("speakers.japanese.female"));
        this.men.put("bf", configuration.getString("speakers.belgium-french.male"));
        this.men.put("bp", configuration.getString("speakers.brazilian-portuguese.male"));
        this.men.put("en-gb", configuration.getString("speakers.british-english.male"));
        this.men.put("cf", configuration.getString("speakers.canadian-french.male"));
        this.men.put("cs", configuration.getString("speakers.czech.male"));
        this.men.put("dan", configuration.getString("speakers.danish.male"));
        this.men.put("en", configuration.getString("speakers.english.male"));
        this.men.put("fi", configuration.getString("speakers.finnish.male"));
        this.men.put("fr", configuration.getString("speakers.french.male"));
        this.men.put("de", configuration.getString("speakers.german.male"));
        this.men.put("el", configuration.getString("speakers.greek.male"));
        this.men.put("it", configuration.getString("speakers.italian.male"));
        this.men.put("nl", configuration.getString("speakers.netherlands-dutch.male"));
        this.men.put("no", configuration.getString("speakers.norwegian.male"));
        this.men.put("pl", configuration.getString("speakers.polish.male"));
        this.men.put("pt", configuration.getString("speakers.portuguese.male"));
        this.men.put("ru", configuration.getString("speakers.russian.male"));
        this.men.put("ar", configuration.getString("speakers.saudi-arabia-arabic.male"));
        this.men.put("ca", configuration.getString("speakers.spain-catalan.male"));
        this.men.put("es", configuration.getString("speakers.spanish.male"));
        this.men.put("sv", configuration.getString("speakers.swedish.male"));
        this.men.put("tr", configuration.getString("speakers.turkish.male"));
        this.men.put("zh-cn", configuration.getString("speakers.mandarin-chinese.male"));
        this.men.put("ja", configuration.getString("speakers.japanese.male"));
    }

    public void onReceive(Object message) throws Exception {
        block6: {
            Class<?> klass = message.getClass();
            ActorRef self = this.self();
            ActorRef sender = this.sender();
            if (SpeechSynthesizerRequest.class.equals(klass)) {
                try {
                    URI uri = this.synthesize(message);
                    if (sender != null) {
                        sender.tell((Object)new SpeechSynthesizerResponse((Object)uri), self);
                    }
                    break block6;
                }
                catch (Exception exception) {
                    this.logger.error("There was an exception while trying to synthesize message: " + exception);
                    if (sender != null) {
                        sender.tell((Object)new SpeechSynthesizerResponse((Throwable)exception), self);
                    }
                    break block6;
                }
            }
            if (GetSpeechSynthesizerInfo.class.equals(klass)) {
                sender.tell((Object)new SpeechSynthesizerResponse((Object)this.info()), self);
            }
        }
    }

    private String speaker(String gender, String language) {
        String speaker = null;
        if ("woman".equalsIgnoreCase(gender)) {
            speaker = this.women.get(language);
            if (speaker == null || speaker.isEmpty()) {
                speaker = this.men.get(language);
            }
        } else if ("man".equalsIgnoreCase(gender)) {
            speaker = this.men.get(language);
            if (speaker == null || speaker.isEmpty()) {
                speaker = this.women.get(language);
            }
        } else {
            return null;
        }
        return speaker;
    }

    private URI synthesize(Object message) throws IOException, SpeechSynthesizerException {
        SpeechSynthesizerRequest request = (SpeechSynthesizerRequest)message;
        String gender = request.gender();
        String language = request.language();
        String text = request.text();
        String speaker = this.speaker(gender, language);
        if (speaker == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("There is no suitable speaker to synthesize " + request.language());
            }
            throw new IllegalArgumentException("There is no suitable speaker to synthesize " + request.language());
        }
        ArrayList<Object> query = new ArrayList<Object>();
        query.addAll(parameters);
        query.add(new BasicNameValuePair("req_voice", speaker));
        query.add(new BasicNameValuePair("req_text", text));
        HttpPost post = new HttpPost(this.service);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(query, "UTF-8");
        post.setEntity((HttpEntity)entity);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)post);
        StatusLine line = response.getStatusLine();
        int status = line.getStatusCode();
        if (status == 200) {
            Map results = HttpUtils.toMap((HttpEntity)response.getEntity());
            if ("OK".equals(results.get("res"))) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("AcapelaSpeechSynthesizer success!");
                }
                String ret = (String)results.get("snd_url") + "#hash=" + HashGenerator.hashMessage((String)gender, (String)language, (String)text);
                return URI.create(ret);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("AcapelaSpeechSynthesizer error code: " + (String)results.get("err_code") + " error message: " + (String)results.get("err_msg"));
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append((String)results.get("err_code")).append(" ").append((String)results.get("err_msg"));
            throw new SpeechSynthesizerException(buffer.toString());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AcapelaSpeechSynthesizer error, status code: " + line.getStatusCode() + " reason phrase: " + line.getReasonPhrase());
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(line.getStatusCode()).append(" ").append(line.getReasonPhrase());
        throw new SpeechSynthesizerException(buffer.toString());
    }

    static {
        parameters.add((NameValuePair)new BasicNameValuePair("prot_vers", version));
        parameters.add((NameValuePair)new BasicNameValuePair("cl_env", environment));
        parameters.add((NameValuePair)new BasicNameValuePair("cl_vers", client));
        parameters.add((NameValuePair)new BasicNameValuePair("req_type", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_snd_id", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_vol", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_spd", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_vct", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_eq1", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_eq2", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_eq3", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_eq4", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_snd_type", mime));
        parameters.add((NameValuePair)new BasicNameValuePair("req_snd_ext", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_snd_kbps", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_alt_snd_type", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_alt_snd_ext", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_alt_snd_kbps", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_wp", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_bp", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_mp", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_comment", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_start_time", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_timeout", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_asw_type", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_asw_as_alt_snd", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_err_as_id3", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_echo", null));
        parameters.add((NameValuePair)new BasicNameValuePair("req_asw_redirect_url", null));
    }
}

