/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.util.List;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.managers.LocationManager;

public class NATHelperProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(NATHelperProcessor.class);
    private LocationManager locationManager = LocationManager.getLocationManager();

    public NATHelperProcessor(ProcessorChain callback) {
        super(callback);
    }

    public NATHelperProcessor(String name, ProcessorChain callback) {
        super(name, callback);
    }

    public String getName() {
        return "NAT Helper Processor";
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    private void processResponse(SIPMutableMessage message) {
        SipServletResponse response = (SipServletResponse)message.getContent();
        SipServletRequest request = response.getRequest();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processResponse()");
            LOG.trace((Object)(">> request  came from host/port:" + request.getRemoteHost() + ":" + request.getRemotePort()));
            LOG.trace((Object)(">> message  coming from host:   " + message.getSourceRemoteAddress()));
            LOG.trace((Object)(">> response coming from Contact:" + response.getHeader("Contact")));
        }
        SipURI fromURI = (SipURI)request.getFrom().getURI();
        SipURI contactURI = null;
        if (this.isRoutedAddress(request.getRemoteHost())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("RouteAddress " + request.getRemoteHost() + " MUST not be fixed " + fromURI.toString()));
            }
            return;
        }
        contactURI = ConfigurationCache.getSipFactory().createSipURI(fromURI.getUser(), request.getRemoteHost());
        contactURI.setPort(request.getRemotePort());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Patching NATed Contact Address from: " + request.getHeader("Contact") + " to: " + contactURI.toString()));
        }
        try {
            if (response.getMethod().equals("REGISTER")) {
                if (!response.getAddressHeaders("Contact").hasNext()) {
                    response.setAddressHeader("Contact", ConfigurationCache.getSipFactory().createAddress((URI)contactURI));
                } else {
                    LOG.warn((Object)("Contact address exists, CANNOT patch NATed Contact Address to: " + contactURI.toString()));
                }
            }
        }
        catch (ServletParseException e) {
            LOG.error((Object)("CANNOT Patch NATed Contact Address to: " + contactURI.toString()), (Throwable)e);
        }
        message.setContent((Object)response);
    }

    private void processRequest(SIPMutableMessage message) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)message.toString());
        }
        SipServletRequest request = (SipServletRequest)message.getContent();
        SipURI toURI = (SipURI)request.getTo().getURI();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processRequest()");
            LOG.trace((Object)(">> request  came from host/port:" + request.getRemoteHost() + ":" + request.getRemotePort()));
            LOG.trace((Object)(">> message  coming from host:   " + message.getSourceRemoteAddress()));
            LOG.trace((Object)(">> request  coming from Contact:" + request.getHeader("Contact")));
            LOG.trace((Object)(">> request  is inital          :" + request.isInitial()));
            LOG.trace((Object)(">> request  direction          :" + message.getDirection()));
        }
        message.setContent((Object)request);
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public String getVersion() {
        return "1.0.0";
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        if (sm instanceof SipServletRequest) {
            this.processRequest(m);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse(m);
        }
    }

    private boolean isRoutedAddress(String ipAddress) {
        List localNetworks = ConfigurationCache.getLocalNetworks();
        for (String localNetwork : localNetworks) {
            SubnetUtils utils;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Traversing localNetworks " + localNetwork));
            }
            if ((utils = new SubnetUtils(localNetwork)).getInfo().isInRange(ipAddress)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ipAddress " + ipAddress + " Is in network " + localNetwork));
                }
                return true;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("ipAddress " + ipAddress + " Is NOT in network " + localNetwork));
        }
        return false;
    }
}

